/*
 * Decompiled with CFR 0.152.
 */
package griffon.lanterna;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.GUIScreen;
import org.codehaus.griffon.runtime.util.AbstractUIThreadHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanternaUIThreadHandler
extends AbstractUIThreadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LanternaUIThreadHandler.class);
    private final GUIScreen screen;

    public LanternaUIThreadHandler(GUIScreen screen) {
        this.screen = screen;
    }

    public boolean isUIThread() {
        boolean isUIThread = this.screen.isInEventThread();
        if (LOG.isTraceEnabled()) {
            LOG.trace("isUIThread? " + isUIThread);
        }
        return isUIThread;
    }

    public void executeAsync(Runnable runnable) {
        this.executeSync(runnable);
    }

    public void executeSync(final Runnable runnable) {
        if (this.isUIThread()) {
            runnable.run();
        } else {
            this.screen.runInEventThread(new Action(){

                public void doAction() {
                    runnable.run();
                }
            });
        }
    }
}

