/*
 * Decompiled with CFR 0.152.
 */
package griffon.lanterna;

import com.googlecode.lanterna.TerminalFacade;
import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.gui.Window;
import griffon.application.StandaloneGriffonApplication;
import griffon.core.UIThreadManager;
import griffon.lanterna.ConfigurableWindowDisplayHandler;
import griffon.lanterna.LanternaGriffonApplication;
import griffon.lanterna.LanternaUIThreadHandler;
import griffon.lanterna.WindowDisplayHandler;
import griffon.lanterna.WindowManager;
import griffon.util.GriffonExceptionHandler;
import griffon.util.UIThreadHandler;
import java.lang.reflect.InvocationTargetException;
import org.codehaus.griffon.runtime.core.AbstractGriffonApplication;

public abstract class AbstractLanternaGriffonApplication
extends AbstractGriffonApplication
implements LanternaGriffonApplication,
StandaloneGriffonApplication {
    private final WindowManager windowManager;
    private WindowDisplayHandler windowDisplayHandler;
    private final WindowDisplayHandler defaultWindowDisplayHandler = new ConfigurableWindowDisplayHandler();
    private static final Class[] CTOR_ARGS = new Class[]{String[].class};
    private final GUIScreen screen = TerminalFacade.createGUIScreen();

    public AbstractLanternaGriffonApplication() {
        this(EMPTY_ARGS);
    }

    public AbstractLanternaGriffonApplication(String[] args) {
        super(args);
        this.windowManager = new WindowManager(this);
        UIThreadManager.getInstance().setUIThreadHandler(this.getUIThreadHandler(this.screen));
        this.addShutdownHandler(this.windowManager);
    }

    @Override
    public GUIScreen getScreen() {
        return this.screen;
    }

    @Override
    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    @Override
    public WindowDisplayHandler getWindowDisplayHandler() {
        return this.windowDisplayHandler;
    }

    @Override
    public void setWindowDisplayHandler(WindowDisplayHandler windowDisplayHandler) {
        this.windowDisplayHandler = windowDisplayHandler;
    }

    protected UIThreadHandler getUIThreadHandler(GUIScreen screen) {
        return new LanternaUIThreadHandler(screen);
    }

    @Override
    public final WindowDisplayHandler resolveWindowDisplayHandler() {
        return this.windowDisplayHandler != null ? this.windowDisplayHandler : this.defaultWindowDisplayHandler;
    }

    public void bootstrap() {
        this.initialize();
        this.screen.getScreen().startScreen();
    }

    public void realize() {
        this.startup();
    }

    public void show() {
        Window startingWindow = this.windowManager.getStartingWindow();
        this.windowManager.show(startingWindow);
        this.callReady(startingWindow);
    }

    public boolean shutdown() {
        if (super.shutdown()) {
            this.exit();
        }
        return false;
    }

    public void exit() {
        this.screen.getScreen().stopScreen();
        System.exit(0);
    }

    public Object createApplicationContainer() {
        return null;
    }

    protected void callReady(Window startingWindow) {
        this.ready();
    }

    public static void run(Class applicationClass, String[] args) {
        GriffonExceptionHandler.registerExceptionHandler();
        StandaloneGriffonApplication app = null;
        try {
            app = (StandaloneGriffonApplication)applicationClass.getDeclaredConstructor(CTOR_ARGS).newInstance(new Object[]{args});
            app.bootstrap();
            app.realize();
            app.show();
        }
        catch (InstantiationException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        catch (IllegalAccessException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        catch (InvocationTargetException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        catch (NoSuchMethodException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
    }
}

