/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.mutator;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExprStmt;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.mutator.Mutator;

public final class LastExpressionMutator {
    @NotNull
    private final Mutator mutator;

    public static JsNode mutateLastExpression(@NotNull JsNode node, @NotNull Mutator mutator) {
        return new LastExpressionMutator(mutator).apply(node);
    }

    private LastExpressionMutator(@NotNull Mutator mutator) {
        this.mutator = mutator;
    }

    @NotNull
    private JsNode apply(@NotNull JsNode node) {
        if (node instanceof JsBlock) {
            return this.applyToBlock((JsBlock)node);
        }
        if (node instanceof JsIf) {
            return this.applyToIf((JsIf)node);
        }
        if (node instanceof JsExprStmt) {
            return this.applyToStatement((JsExprStmt)node);
        }
        return this.mutator.mutate(node);
    }

    @NotNull
    private JsNode applyToStatement(@NotNull JsExprStmt node) {
        return JsAstUtils.convertToStatement(this.apply(node.getExpression()));
    }

    @NotNull
    private JsNode applyToIf(@NotNull JsIf node) {
        node.setThenStmt(JsAstUtils.convertToStatement(this.apply(node.getThenStmt())));
        JsStatement elseStmt = node.getElseStmt();
        if (elseStmt != null) {
            node.setElseStmt(JsAstUtils.convertToStatement(this.apply(elseStmt)));
        }
        return node;
    }

    @NotNull
    private JsNode applyToBlock(@NotNull JsBlock node) {
        List<JsStatement> statements = node.getStatements();
        if (statements.isEmpty()) {
            return node;
        }
        int size = statements.size();
        statements.set(size - 1, JsAstUtils.convertToStatement(this.apply(statements.get(size - 1))));
        return node;
    }
}

