/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.dangerous;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.dangerous.DangerousData;

public final class DangerousTranslator
extends AbstractTranslator {
    @NotNull
    private final DangerousData data;

    @NotNull
    public static JsNode translate(@NotNull DangerousData data, @NotNull TranslationContext context) {
        assert (data.exists());
        DangerousTranslator translator = new DangerousTranslator(data, context);
        return translator.translate();
    }

    private DangerousTranslator(@NotNull DangerousData data, @NotNull TranslationContext context) {
        super(context);
        this.data = data;
    }

    @NotNull
    private JsNode translate() {
        Map<JetExpression, JsName> aliasesForExpressions = this.translateAllExpressionsAndCreateAliasesForThem(this.data.getNodesToBeGeneratedBefore());
        TranslationContext contextWithAliases = this.context().innerContextWithAliasesForExpressions(aliasesForExpressions);
        return Translation.doTranslateExpression(this.data.getRootNode(), contextWithAliases);
    }

    @NotNull
    private Map<JetExpression, JsName> translateAllExpressionsAndCreateAliasesForThem(@NotNull List<JetExpression> expressions) {
        HashMap<JetExpression, JsName> aliasesForExpressions = Maps.newHashMap();
        for (JetExpression expression : expressions) {
            JsExpression translatedExpression = Translation.translateAsExpression(expression, this.context());
            TemporaryVariable aliasForExpression = this.context().declareTemporary(translatedExpression);
            this.context().addStatementToCurrentBlock(aliasForExpression.assignmentExpression().makeStmt());
            aliasesForExpressions.put(expression, aliasForExpression.name());
        }
        return aliasesForExpressions;
    }
}

