/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.closure;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.closure.ClosureContext;

public class CaptureClosureVisitor
extends JetTreeVisitor<ClosureContext> {
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final JetElement functionElement;

    CaptureClosureVisitor(@NotNull JetElement functionElement, @NotNull BindingContext bindingContext) {
        this.bindingContext = bindingContext;
        this.functionElement = functionElement;
    }

    @Override
    public Void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression, @NotNull ClosureContext context) {
        expression.acceptChildren(this, context);
        DeclarationDescriptor descriptor = BindingUtils.getNullableDescriptorForReferenceExpression(this.bindingContext, expression);
        if (!(descriptor instanceof VariableDescriptor)) {
            return null;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor;
        PsiElement variableDeclaration = BindingContextUtils.descriptorToDeclaration(this.bindingContext, descriptor);
        if (variableDeclaration == null) {
            return null;
        }
        if (PsiTreeUtil.isAncestor(this.functionElement, variableDeclaration, false)) {
            return null;
        }
        boolean isProperty = variableDescriptor instanceof PropertyDescriptor;
        if (!isProperty && !variableDescriptor.isVar() && variableDeclaration instanceof JetProperty) {
            context.put(variableDescriptor);
            return null;
        }
        boolean isLoopParameter = variableDeclaration.getNode().getElementType().equals(JetNodeTypes.LOOP_PARAMETER);
        if (isLoopParameter) {
            context.put(variableDescriptor);
        }
        return null;
    }
}

