/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsThisRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.intrinsic.Intrinsic;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class TranslationUtils {
    private TranslationUtils() {
    }

    @NotNull
    public static JsPropertyInitializer translateFunctionAsEcma5PropertyDescriptor(@NotNull JsFunction function, @NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context) {
        if (JsDescriptorUtils.isExtension(descriptor)) {
            return TranslationUtils.translateExtensionFunctionAsEcma5PropertyDescriptor(function, descriptor, context);
        }
        JsStringLiteral getOrSet = context.program().getStringLiteral(descriptor instanceof PropertyGetterDescriptor ? "get" : "set");
        return new JsPropertyInitializer(getOrSet, function);
    }

    @NotNull
    private static JsPropertyInitializer translateExtensionFunctionAsEcma5PropertyDescriptor(@NotNull JsFunction function, @NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context) {
        JsObjectLiteral meta = new JsObjectLiteral();
        meta.getPropertyInitializers().add(new JsPropertyInitializer(context.program().getStringLiteral("value"), function));
        if (descriptor.getModality().isOverridable()) {
            meta.getPropertyInitializers().add(context.namer().writablePropertyDescriptorField());
        }
        return new JsPropertyInitializer(context.getNameForDescriptor(descriptor).makeRef(), meta);
    }

    @NotNull
    public static JsBinaryOperation notNullCheck(@NotNull TranslationContext context, @NotNull JsExpression expressionToCheck) {
        JsNullLiteral nullLiteral = context.program().getNullLiteral();
        return JsAstUtils.inequality(expressionToCheck, nullLiteral);
    }

    @NotNull
    public static JsBinaryOperation isNullCheck(@NotNull TranslationContext context, @NotNull JsExpression expressionToCheck) {
        JsNullLiteral nullLiteral = context.program().getNullLiteral();
        return JsAstUtils.equality(expressionToCheck, nullLiteral);
    }

    @NotNull
    public static List<JsExpression> translateArgumentList(@NotNull TranslationContext context, @NotNull List<? extends ValueArgument> jetArguments) {
        ArrayList<JsExpression> jsArguments = new ArrayList<JsExpression>();
        for (ValueArgument valueArgument : jetArguments) {
            jsArguments.add(TranslationUtils.translateArgument(context, valueArgument));
        }
        return jsArguments;
    }

    @NotNull
    private static JsExpression translateArgument(@NotNull TranslationContext context, @NotNull ValueArgument argument) {
        JetExpression jetExpression = argument.getArgumentExpression();
        assert (jetExpression != null) : "Argument with no expression";
        return Translation.translateAsExpression(jetExpression, context);
    }

    @NotNull
    public static JsNameRef backingFieldReference(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor) {
        JsName backingFieldName = context.getNameForDescriptor(descriptor);
        return JsAstUtils.qualified(backingFieldName, new JsThisRef());
    }

    @NotNull
    public static JsExpression assignmentToBackingField(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor, @NotNull JsExpression assignTo) {
        JsNameRef backingFieldReference = TranslationUtils.backingFieldReference(context, descriptor);
        return AstUtil.newAssignment(backingFieldReference, assignTo);
    }

    @Nullable
    public static JsExpression translateInitializerForProperty(@NotNull JetProperty declaration, @NotNull TranslationContext context) {
        JsExpression jsInitExpression = null;
        JetExpression initializer = declaration.getInitializer();
        if (initializer != null) {
            jsInitExpression = Translation.translateAsExpression(initializer, context);
        }
        return jsInitExpression;
    }

    @NotNull
    public static JsNameRef getQualifiedReference(@NotNull TranslationContext context, @NotNull DeclarationDescriptor descriptor) {
        JsName name = context.getNameForDescriptor(descriptor);
        JsNameRef reference = name.makeRef();
        JsNameRef qualifier = context.getQualifierForDescriptor(descriptor);
        if (qualifier != null) {
            JsAstUtils.setQualifier(reference, qualifier);
        }
        return reference;
    }

    @NotNull
    public static JsExpression getThisObject(@NotNull TranslationContext context, @NotNull DeclarationDescriptor correspondingDeclaration) {
        JsName alias;
        if (correspondingDeclaration instanceof ClassDescriptor && (alias = context.aliasingContext().getAliasForThis(correspondingDeclaration)) != null) {
            return alias.makeRef();
        }
        if (correspondingDeclaration instanceof CallableDescriptor) {
            DeclarationDescriptor receiverDescriptor = JsDescriptorUtils.getExpectedReceiverDescriptor((CallableDescriptor)correspondingDeclaration);
            assert (receiverDescriptor != null);
            JsName alias2 = context.aliasingContext().getAliasForThis(receiverDescriptor);
            if (alias2 != null) {
                return alias2.makeRef();
            }
        }
        return new JsThisRef();
    }

    @NotNull
    public static List<JsExpression> translateExpressionList(@NotNull TranslationContext context, @NotNull List<JetExpression> expressions) {
        ArrayList<JsExpression> result = new ArrayList<JsExpression>();
        for (JetExpression expression : expressions) {
            result.add(Translation.translateAsExpression(expression, context));
        }
        return result;
    }

    @NotNull
    public static JsExpression translateBaseExpression(@NotNull TranslationContext context, @NotNull JetUnaryExpression expression) {
        JetExpression baseExpression = PsiUtils.getBaseExpression(expression);
        return Translation.translateAsExpression(baseExpression, context);
    }

    @NotNull
    public static JsExpression translateLeftExpression(@NotNull TranslationContext context, @NotNull JetBinaryExpression expression) {
        return Translation.translateAsExpression(expression.getLeft(), context);
    }

    @NotNull
    public static JsExpression translateRightExpression(@NotNull TranslationContext context, @NotNull JetBinaryExpression expression) {
        JetExpression rightExpression = expression.getRight();
        assert (rightExpression != null) : "Binary expression should have a right expression";
        return Translation.translateAsExpression(rightExpression, context);
    }

    public static boolean isIntrinsicOperation(@NotNull TranslationContext context, @NotNull JetOperationExpression expression) {
        FunctionDescriptor operationDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(context.bindingContext(), expression);
        if (operationDescriptor == null) {
            return true;
        }
        return context.intrinsics().isIntrinsic(operationDescriptor);
    }

    @NotNull
    public static JsNameRef getMethodReferenceForOverloadedOperation(@NotNull TranslationContext context, @NotNull JetOperationExpression expression) {
        FunctionDescriptor overloadedOperationDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(context.bindingContext(), expression);
        assert (overloadedOperationDescriptor != null);
        JsNameRef overloadedOperationReference = context.getNameForDescriptor(overloadedOperationDescriptor).makeRef();
        assert (overloadedOperationReference != null);
        return overloadedOperationReference;
    }

    @NotNull
    public static JsNumberLiteral zeroLiteral(@NotNull TranslationContext context) {
        return context.program().getNumberLiteral(0.0);
    }

    @NotNull
    public static JsExpression applyIntrinsicToBinaryExpression(@NotNull TranslationContext context, @NotNull Intrinsic intrinsic, @NotNull JetBinaryExpression binaryExpression) {
        JsExpression left = TranslationUtils.translateLeftExpression(context, binaryExpression);
        JsExpression right = TranslationUtils.translateRightExpression(context, binaryExpression);
        return intrinsic.apply(left, Arrays.asList(right), context);
    }

    @Nullable
    public static JsExpression resolveThisObjectForResolvedCall(@NotNull ResolvedCall<?> call, @NotNull TranslationContext context) {
        ReceiverDescriptor thisObject = call.getThisObject();
        if (!thisObject.exists()) {
            return null;
        }
        DeclarationDescriptor expectedThisDescriptor = JsDescriptorUtils.getDeclarationDescriptorForReceiver(thisObject);
        return TranslationUtils.getThisObject(context, expectedThisDescriptor);
    }
}

