/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetLoopExpression;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetPattern;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypePattern;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.Namer;

public final class PsiUtils {
    private PsiUtils() {
    }

    @Nullable
    public static JetSimpleNameExpression getSelectorAsSimpleName(@NotNull JetQualifiedExpression expression) {
        JetExpression selectorExpression = PsiUtils.getSelector(expression);
        if (!(selectorExpression instanceof JetSimpleNameExpression)) {
            return null;
        }
        return (JetSimpleNameExpression)selectorExpression;
    }

    @NotNull
    public static JetExpression getSelector(@NotNull JetQualifiedExpression expression) {
        JetExpression selectorExpression = expression.getSelectorExpression();
        assert (selectorExpression != null) : "Selector should not be null.";
        return selectorExpression;
    }

    @NotNull
    public static JetSimpleNameExpression getNotNullSimpleNameSelector(@NotNull JetQualifiedExpression expression) {
        JetSimpleNameExpression selectorAsSimpleName = PsiUtils.getSelectorAsSimpleName(expression);
        assert (selectorAsSimpleName != null);
        return selectorAsSimpleName;
    }

    @NotNull
    public static JetToken getOperationToken(@NotNull JetOperationExpression expression) {
        JetSimpleNameExpression operationExpression = expression.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType instanceof JetToken) : "Unary expression should have operation token of type JetToken";
        return (JetToken)elementType;
    }

    @NotNull
    public static JetExpression getBaseExpression(@NotNull JetUnaryExpression expression) {
        JetExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        return baseExpression;
    }

    public static boolean isPrefix(@NotNull JetUnaryExpression expression) {
        return expression instanceof JetPrefixExpression;
    }

    public static boolean isAssignment(JetToken token) {
        return token == JetTokens.EQ;
    }

    public static boolean isBackingFieldReference(@NotNull JetSimpleNameExpression expression) {
        return expression.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER;
    }

    public static boolean isInOrNotInOperation(@NotNull JetBinaryExpression binaryExpression) {
        return PsiUtils.isInOperation(binaryExpression) || PsiUtils.isNotInOperation(binaryExpression);
    }

    public static boolean isNotInOperation(@NotNull JetBinaryExpression binaryExpression) {
        return binaryExpression.getOperationToken() == JetTokens.NOT_IN;
    }

    private static boolean isInOperation(@NotNull JetBinaryExpression binaryExpression) {
        return binaryExpression.getOperationToken() == JetTokens.IN_KEYWORD;
    }

    @NotNull
    public static JetExpression getCallee(@NotNull JetCallExpression expression) {
        JetExpression calleeExpression = expression.getCalleeExpression();
        assert (calleeExpression != null);
        return calleeExpression;
    }

    @NotNull
    public static JetExpression getLoopBody(@NotNull JetLoopExpression expression) {
        JetExpression body = expression.getBody();
        assert (body != null) : "Loops cannot have null bodies.";
        return body;
    }

    @NotNull
    public static JetParameter getLoopParameter(@NotNull JetForExpression expression) {
        JetParameter loopParameter = expression.getLoopParameter();
        assert (loopParameter != null);
        return loopParameter;
    }

    @NotNull
    public static List<JetParameter> getPrimaryConstructorParameters(@NotNull JetClassOrObject classDeclaration) {
        if (classDeclaration instanceof JetClass) {
            return ((JetClass)classDeclaration).getPrimaryConstructorParameters();
        }
        return Collections.emptyList();
    }

    @NotNull
    public static JetObjectDeclaration getObjectDeclarationForName(@NotNull JetObjectDeclarationName name) {
        PsiElement parent = name.getParent();
        assert (parent instanceof JetObjectDeclaration) : "ObjectDeclarationName should have a parent of type ObjectDeclaration.";
        return (JetObjectDeclaration)parent;
    }

    @NotNull
    public static JetObjectDeclarationName getObjectDeclarationName(@NotNull JetObjectDeclaration objectDeclaration) {
        JetObjectDeclarationName nameAsDeclaration = objectDeclaration.getNameAsDeclaration();
        assert (nameAsDeclaration != null);
        return nameAsDeclaration;
    }

    @NotNull
    public static String getNamespaceName(@NotNull JetFile psiFile) {
        JetNamespaceHeader namespaceHeader = psiFile.getNamespaceHeader();
        String name = namespaceHeader.getName();
        assert (name != null) : "NamespaceHeader must have a name";
        if (name.isEmpty()) {
            return Namer.getRootNamespaceName();
        }
        return name;
    }

    @NotNull
    public static JetExpression getLoopRange(@NotNull JetForExpression expression) {
        JetExpression rangeExpression = expression.getLoopRange();
        assert (rangeExpression != null);
        return rangeExpression;
    }

    @NotNull
    public static JetPattern getPattern(@NotNull JetIsExpression expression) {
        JetPattern pattern = expression.getPattern();
        assert (pattern != null) : "Pattern should not be null";
        return pattern;
    }

    @NotNull
    public static JetTypeReference getTypeReference(@NotNull JetTypePattern pattern) {
        JetTypeReference typeReference = pattern.getTypeReference();
        assert (typeReference != null) : "Type pattern should contain a type reference";
        return typeReference;
    }
}

