/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;

public final class PartiallyOrderedSet<Element> {
    @NotNull
    private final List<Arc> arcs = Lists.newArrayList();
    @NotNull
    private final Map<Element, Integer> incomingArcs = Maps.newHashMap();
    @NotNull
    private final List<Element> elementsWithZeroIncoming = Lists.newArrayList();

    public PartiallyOrderedSet(@NotNull Collection<Element> elements, @NotNull Order<Element> order) {
        this.elementsWithZeroIncoming.addAll(elements);
        for (Element first : elements) {
            for (Element second : elements) {
                if (!order.firstDependsOnSecond(first, second)) continue;
                this.arcs.add(new Arc(first, second));
                this.increaseIncomingCount(second);
            }
        }
    }

    private void increaseIncomingCount(@NotNull Element element) {
        if (!this.incomingArcs.containsKey(element)) {
            this.incomingArcs.put(element, 1);
            this.elementsWithZeroIncoming.remove(element);
        } else {
            Integer count = this.incomingArcs.get(element);
            this.incomingArcs.put(element, count + 1);
        }
    }

    private void decreaseIncomingCount(@NotNull Element element) {
        assert (this.incomingArcs.containsKey(element));
        Integer count = this.incomingArcs.get(element);
        if (count == 1) {
            this.incomingArcs.remove(element);
            this.elementsWithZeroIncoming.add(element);
        } else {
            this.incomingArcs.put(element, count - 1);
        }
    }

    @NotNull
    public List<Element> partiallySortedElements() {
        ArrayList<Element> result = Lists.newArrayList();
        while (!this.elementsWithZeroIncoming.isEmpty()) {
            result.add(this.getNextElement());
        }
        return result;
    }

    @NotNull
    private Element getNextElement() {
        Element elementWithZeroIncoming = this.getElementWithZeroIncoming();
        for (Arc arc : this.arcs) {
            if (arc.from != elementWithZeroIncoming) continue;
            this.decreaseIncomingCount(arc.to);
        }
        return elementWithZeroIncoming;
    }

    @NotNull
    private Element getElementWithZeroIncoming() {
        int indexOfLast = this.elementsWithZeroIncoming.size() - 1;
        Element element = this.elementsWithZeroIncoming.get(indexOfLast);
        this.elementsWithZeroIncoming.remove(indexOfLast);
        return element;
    }

    public static interface Order<Element> {
        public boolean firstDependsOnSecond(@NotNull Element var1, @NotNull Element var2);
    }

    private class Arc {
        @NotNull
        public final Element from;
        @NotNull
        public final Element to;

        private Arc(@NotNull Element from, @NotNull Element to) {
            this.from = from;
            this.to = to;
        }
    }
}

