/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public final class JsDescriptorUtils {
    private JsDescriptorUtils() {
    }

    private static int valueParametersCount(@NotNull FunctionDescriptor functionDescriptor) {
        return functionDescriptor.getValueParameters().size();
    }

    public static boolean hasParameters(@NotNull FunctionDescriptor functionDescriptor) {
        return JsDescriptorUtils.valueParametersCount(functionDescriptor) > 0;
    }

    public static boolean isEquals(@NotNull FunctionDescriptor functionDescriptor) {
        return functionDescriptor.getName().equals(OperatorConventions.EQUALS);
    }

    public static boolean isCompareTo(@NotNull FunctionDescriptor functionDescriptor) {
        return functionDescriptor.getName().equals(OperatorConventions.COMPARE_TO);
    }

    public static boolean isConstructorDescriptor(@NotNull CallableDescriptor descriptor) {
        return descriptor instanceof ConstructorDescriptor;
    }

    @NotNull
    public static FunctionDescriptor getFunctionByName(@NotNull JetScope scope, @NotNull Name name) {
        Set<FunctionDescriptor> functionDescriptors = scope.getFunctions(name);
        assert (functionDescriptors.size() == 1) : "In scope " + scope + " supposed to be exactly one " + name + " function.\n" + "Found: " + functionDescriptors.size();
        Iterator<FunctionDescriptor> i$ = functionDescriptors.iterator();
        if (i$.hasNext()) {
            FunctionDescriptor descriptor = i$.next();
            return descriptor;
        }
        throw new AssertionError((Object)("In scope " + scope + " supposed to be exactly one " + name + " function."));
    }

    @NotNull
    public static PropertyDescriptor getPropertyByName(@NotNull JetScope scope, @NotNull Name name) {
        Set<VariableDescriptor> variables = scope.getProperties(name);
        assert (variables.size() == 1) : "Actual size: " + variables.size();
        VariableDescriptor variable = variables.iterator().next();
        PropertyDescriptor descriptor = (PropertyDescriptor)variable;
        assert (descriptor != null) : "Must have a descriptor.";
        return descriptor;
    }

    @Nullable
    public static ClassDescriptor findAncestorClass(@NotNull List<ClassDescriptor> superclassDescriptors) {
        for (ClassDescriptor descriptor : superclassDescriptors) {
            if (descriptor.getKind() != ClassKind.CLASS) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public static List<ClassDescriptor> getSuperclassDescriptors(@NotNull ClassDescriptor classDescriptor) {
        Collection<? extends JetType> superclassTypes = classDescriptor.getTypeConstructor().getSupertypes();
        ArrayList<ClassDescriptor> superClassDescriptors = new ArrayList<ClassDescriptor>();
        for (JetType jetType : superclassTypes) {
            ClassDescriptor result = JsDescriptorUtils.getClassDescriptorForType(jetType);
            if (!BindingUtils.isNotAny(result)) continue;
            superClassDescriptors.add(result);
        }
        return superClassDescriptors;
    }

    @Nullable
    public static ClassDescriptor getSuperclass(@NotNull ClassDescriptor classDescriptor) {
        return JsDescriptorUtils.findAncestorClass(JsDescriptorUtils.getSuperclassDescriptors(classDescriptor));
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForType(@NotNull JetType type) {
        ClassifierDescriptor superClassDescriptor = type.getConstructor().getDeclarationDescriptor();
        assert (superClassDescriptor instanceof ClassDescriptor) : "Superclass descriptor of a type should be of type ClassDescriptor";
        return (ClassDescriptor)superClassDescriptor;
    }

    @NotNull
    public static DeclarationDescriptor getContainingDeclaration(@NotNull DeclarationDescriptor descriptor) {
        DeclarationDescriptor containing = descriptor.getContainingDeclaration();
        assert (containing != null) : "Should be called on objects that have containing declaration.";
        return containing;
    }

    public static boolean isExtension(@NotNull CallableDescriptor functionDescriptor) {
        return functionDescriptor.getReceiverParameter().exists();
    }

    @NotNull
    public static String getNameForNamespace(@NotNull NamespaceDescriptor descriptor) {
        if (descriptor.getContainingDeclaration() instanceof ModuleDescriptor) {
            return Namer.getRootNamespaceName();
        }
        return descriptor.getName().getName();
    }

    @Nullable
    public static DeclarationDescriptor getExpectedThisDescriptor(@NotNull CallableDescriptor callableDescriptor) {
        ReceiverDescriptor expectedThisObject = callableDescriptor.getExpectedThisObject();
        if (!expectedThisObject.exists()) {
            return null;
        }
        return JsDescriptorUtils.getDeclarationDescriptorForReceiver(expectedThisObject);
    }

    @NotNull
    public static DeclarationDescriptor getDeclarationDescriptorForReceiver(@NotNull ReceiverDescriptor receiverParameter) {
        ClassifierDescriptor declarationDescriptor = receiverParameter.getType().getConstructor().getDeclarationDescriptor();
        assert (declarationDescriptor != null);
        return declarationDescriptor.getOriginal();
    }

    @Nullable
    public static DeclarationDescriptor getExpectedReceiverDescriptor(@NotNull CallableDescriptor callableDescriptor) {
        ReceiverDescriptor receiverParameter = callableDescriptor.getReceiverParameter();
        if (!receiverParameter.exists()) {
            return null;
        }
        return JsDescriptorUtils.getDeclarationDescriptorForReceiver(receiverParameter);
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull DeclarationDescriptor descriptor) {
        for (DeclarationDescriptor containing = descriptor.getContainingDeclaration(); containing != null; containing = containing.getContainingDeclaration()) {
            if (!(containing instanceof ClassDescriptor)) continue;
            return (ClassDescriptor)containing;
        }
        return null;
    }

    @NotNull
    public static List<ClassDescriptor> getAllClassesDefinedInNamespace(@NotNull NamespaceDescriptor namespaceDescriptor) {
        ArrayList<ClassDescriptor> classDescriptors = Lists.newArrayList();
        for (DeclarationDescriptor descriptor : JsDescriptorUtils.getContainedDescriptorsWhichAreNotPredefined(namespaceDescriptor)) {
            if (!(descriptor instanceof ClassDescriptor)) continue;
            classDescriptors.add((ClassDescriptor)descriptor);
        }
        return classDescriptors;
    }

    @NotNull
    public static List<NamespaceDescriptor> getNestedNamespaces(@NotNull NamespaceDescriptor namespaceDescriptor) {
        ArrayList<NamespaceDescriptor> result = Lists.newArrayList();
        for (DeclarationDescriptor descriptor : JsDescriptorUtils.getContainedDescriptorsWhichAreNotPredefined(namespaceDescriptor)) {
            if (!(descriptor instanceof NamespaceDescriptor)) continue;
            result.add((NamespaceDescriptor)descriptor);
        }
        return result;
    }

    @Nullable
    public static FunctionDescriptor getOverriddenDescriptor(@NotNull FunctionDescriptor functionDescriptor) {
        Set<? extends FunctionDescriptor> overriddenDescriptors = functionDescriptor.getOverriddenDescriptors();
        if (overriddenDescriptors.isEmpty()) {
            return null;
        }
        return overriddenDescriptors.iterator().next();
    }

    @NotNull
    public static List<DeclarationDescriptor> getContainedDescriptorsWhichAreNotPredefined(@NotNull NamespaceDescriptor namespace) {
        ArrayList<DeclarationDescriptor> result = Lists.newArrayList();
        for (DeclarationDescriptor descriptor : namespace.getMemberScope().getAllDescriptors()) {
            if (AnnotationsUtils.isPredefinedObject(descriptor)) continue;
            result.add(descriptor);
        }
        return result;
    }

    public static boolean isNamespaceEmpty(@NotNull NamespaceDescriptor namespace) {
        List<DeclarationDescriptor> containedDescriptors = JsDescriptorUtils.getContainedDescriptorsWhichAreNotPredefined(namespace);
        for (DeclarationDescriptor descriptor : containedDescriptors) {
            if (descriptor instanceof NamespaceDescriptor) {
                if (JsDescriptorUtils.isNamespaceEmpty((NamespaceDescriptor)descriptor)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @NotNull
    public static List<NamespaceDescriptor> getNamespaceDescriptorHierarchy(@NotNull NamespaceDescriptor namespaceDescriptor) {
        ArrayList<NamespaceDescriptor> result = Lists.newArrayList(namespaceDescriptor);
        NamespaceDescriptor current = namespaceDescriptor;
        while (!(current.getContainingDeclaration() instanceof ModuleDescriptor)) {
            result.add(current);
            if (!(current.getContainingDeclaration() instanceof NamespaceDescriptor)) break;
            current = (NamespaceDescriptor)current.getContainingDeclaration();
            assert (current != null);
        }
        return result;
    }

    private static boolean isDefaultAccessor(@Nullable PropertyAccessorDescriptor accessorDescriptor) {
        return accessorDescriptor == null || accessorDescriptor.isDefault();
    }

    public static boolean isAsPrivate(@NotNull PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getReceiverParameter().exists() || !JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getGetter()) || !JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getSetter());
    }
}

