/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.k2js.translate.utils.mutator.Mutator;

public final class FunctionBodyTranslator
extends AbstractTranslator {
    @NotNull
    private final FunctionDescriptor descriptor;
    @NotNull
    private final JetDeclarationWithBody declaration;

    @NotNull
    public static JsBlock translateFunctionBody(@NotNull FunctionDescriptor descriptor, @NotNull JetDeclarationWithBody declarationWithBody, @NotNull TranslationContext functionBodyContext) {
        return new FunctionBodyTranslator(descriptor, declarationWithBody, functionBodyContext).translate();
    }

    private FunctionBodyTranslator(@NotNull FunctionDescriptor descriptor, @NotNull JetDeclarationWithBody declaration, @NotNull TranslationContext context) {
        super(context);
        this.descriptor = descriptor;
        this.declaration = declaration;
    }

    @NotNull
    private JsBlock translate() {
        JetExpression jetBodyExpression = this.declaration.getBodyExpression();
        assert (jetBodyExpression != null) : "Cannot translate a body of an abstract function.";
        return this.mayBeWrapWithReturn(Translation.translateExpression(jetBodyExpression, this.context()));
    }

    @NotNull
    private JsBlock mayBeWrapWithReturn(@NotNull JsNode body) {
        if (!this.mustAddReturnToGeneratedFunctionBody()) {
            return JsAstUtils.convertToBlock(body);
        }
        return JsAstUtils.convertToBlock(FunctionBodyTranslator.lastExpressionReturned(body));
    }

    private boolean mustAddReturnToGeneratedFunctionBody() {
        JetType functionReturnType = this.descriptor.getReturnType();
        assert (functionReturnType != null) : "Function return typed type must be resolved.";
        return !this.declaration.hasBlockBody() && !JetStandardClasses.isUnit(functionReturnType);
    }

    @NotNull
    private static JsNode lastExpressionReturned(@NotNull JsNode body) {
        return LastExpressionMutator.mutateLastExpression(body, new Mutator(){

            @Override
            @NotNull
            public JsNode mutate(@NotNull JsNode node) {
                if (!(node instanceof JsExpression)) {
                    return node;
                }
                return new JsReturn((JsExpression)node);
            }
        });
    }
}

