/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PartiallyOrderedSet;

public final class ClassSortingUtils {
    private ClassSortingUtils() {
    }

    @NotNull
    public static List<JetClass> sortUsingInheritanceOrder(@NotNull List<JetClass> elements, @NotNull BindingContext bindingContext) {
        List<ClassDescriptor> descriptors = ClassSortingUtils.descriptorsFromClasses(elements, bindingContext);
        PartiallyOrderedSet<ClassDescriptor> partiallyOrderedSet = new PartiallyOrderedSet<ClassDescriptor>(descriptors, ClassSortingUtils.inheritanceOrder());
        List<JetClass> sortedClasses = ClassSortingUtils.descriptorsToClasses(partiallyOrderedSet.partiallySortedElements(), bindingContext);
        assert (elements.size() == sortedClasses.size());
        return sortedClasses;
    }

    @NotNull
    private static PartiallyOrderedSet.Order<ClassDescriptor> inheritanceOrder() {
        return new PartiallyOrderedSet.Order<ClassDescriptor>(){

            @Override
            public boolean firstDependsOnSecond(@NotNull ClassDescriptor first, @NotNull ClassDescriptor second) {
                return ClassSortingUtils.isDerivedClass(first, second);
            }
        };
    }

    private static boolean isDerivedClass(@NotNull ClassDescriptor ancestor, @NotNull ClassDescriptor derived) {
        return JsDescriptorUtils.getSuperclassDescriptors(derived).contains(ancestor);
    }

    @NotNull
    private static List<JetClass> descriptorsToClasses(@NotNull List<ClassDescriptor> descriptors, @NotNull BindingContext bindingContext) {
        ArrayList<JetClass> sortedClasses = Lists.newArrayList();
        for (ClassDescriptor descriptor : descriptors) {
            sortedClasses.add(BindingUtils.getClassForDescriptor(bindingContext, descriptor));
        }
        return sortedClasses;
    }

    @NotNull
    private static List<ClassDescriptor> descriptorsFromClasses(@NotNull List<JetClass> classesToSort, @NotNull BindingContext bindingContext) {
        ArrayList<ClassDescriptor> descriptorList = new ArrayList<ClassDescriptor>();
        for (JetClass jetClass : classesToSort) {
            descriptorList.add(BindingUtils.getClassDescriptor(bindingContext, jetClass));
        }
        return descriptorList;
    }
}

