/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class BindingUtils {
    private BindingUtils() {
    }

    @NotNull
    private static <E extends PsiElement, D extends DeclarationDescriptor> D getDescriptorForExpression(@NotNull BindingContext context, @NotNull E expression, Class<D> descriptorClass) {
        DeclarationDescriptor descriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, expression);
        assert (descriptor != null);
        assert (descriptorClass.isInstance(descriptor)) : ((Object)expression).toString() + " expected to have of type" + descriptorClass.toString();
        return (D)descriptor;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptor(@NotNull BindingContext context, @NotNull JetClassOrObject declaration) {
        return BindingUtils.getDescriptorForExpression(context, declaration, ClassDescriptor.class);
    }

    @NotNull
    public static NamespaceDescriptor getNamespaceDescriptor(@NotNull BindingContext context, @NotNull JetFile declaration) {
        NamespaceDescriptor namespaceDescriptor = context.get(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, JetPsiUtil.getFQName(declaration));
        assert (namespaceDescriptor != null) : "File should have a namespace descriptor.";
        return namespaceDescriptor;
    }

    @NotNull
    public static FunctionDescriptor getFunctionDescriptor(@NotNull BindingContext context, @NotNull JetDeclarationWithBody declaration) {
        return BindingUtils.getDescriptorForExpression(context, declaration, FunctionDescriptor.class);
    }

    @NotNull
    public static PropertyDescriptor getPropertyDescriptor(@NotNull BindingContext context, @NotNull JetProperty declaration) {
        return BindingUtils.getDescriptorForExpression(context, declaration, PropertyDescriptor.class);
    }

    @NotNull
    public static JetClass getClassForDescriptor(@NotNull BindingContext context, @NotNull ClassDescriptor descriptor) {
        JetClass result = (JetClass)BindingContextUtils.classDescriptorToDeclaration(context, descriptor);
        if (result == null) {
            throw new IllegalStateException("JetClass not found for " + descriptor);
        }
        return result;
    }

    @NotNull
    public static JetFunction getFunctionForDescriptor(@NotNull BindingContext context, @NotNull SimpleFunctionDescriptor descriptor) {
        PsiElement result = BindingContextUtils.callableDescriptorToDeclaration(context, descriptor);
        assert (result instanceof JetFunction) : "SimpleFunctionDescriptor should have declaration of type JetFunction";
        return (JetFunction)result;
    }

    @NotNull
    public static List<JetDeclaration> getDeclarationsForNamespace(@NotNull BindingContext bindingContext, @NotNull NamespaceDescriptor namespace) {
        ArrayList<JetDeclaration> declarations = new ArrayList<JetDeclaration>();
        for (DeclarationDescriptor descriptor : JsDescriptorUtils.getContainedDescriptorsWhichAreNotPredefined(namespace)) {
            JetDeclaration declaration;
            if (descriptor instanceof NamespaceDescriptor || (declaration = BindingUtils.getDeclarationForDescriptor(bindingContext, descriptor)) == null) continue;
            declarations.add(declaration);
        }
        return declarations;
    }

    @Nullable
    private static JetDeclaration getDeclarationForDescriptor(@NotNull BindingContext context, @NotNull DeclarationDescriptor descriptor) {
        PsiElement result = BindingContextUtils.descriptorToDeclaration(context, descriptor);
        if (result == null) {
            return null;
        }
        assert (result instanceof JetDeclaration) : "Descriptor should correspond to an element.";
        return (JetDeclaration)result;
    }

    @NotNull
    private static JetParameter getParameterForDescriptor(@NotNull BindingContext context, @NotNull ValueParameterDescriptor descriptor) {
        PsiElement result = BindingContextUtils.descriptorToDeclaration(context, descriptor);
        assert (result instanceof JetParameter) : "ValueParameterDescriptor should have corresponding JetParameter.";
        return (JetParameter)result;
    }

    public static boolean hasAncestorClass(@NotNull BindingContext context, @NotNull JetClassOrObject classDeclaration) {
        ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(context, classDeclaration);
        List<ClassDescriptor> superclassDescriptors = JsDescriptorUtils.getSuperclassDescriptors(classDescriptor);
        return JsDescriptorUtils.findAncestorClass(superclassDescriptors) != null;
    }

    public static boolean isStatement(@NotNull BindingContext context, @NotNull JetExpression expression) {
        Boolean isStatement = context.get(BindingContext.STATEMENT, expression);
        assert (isStatement != null) : "Invalid behaviour of get(BindingContext.STATEMENT)";
        return isStatement;
    }

    @NotNull
    public static JetType getTypeByReference(@NotNull BindingContext context, @NotNull JetTypeReference typeReference) {
        JetType result = context.get(BindingContext.TYPE, typeReference);
        assert (result != null) : "TypeReference should reference a type";
        return result;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForTypeReference(@NotNull BindingContext context, @NotNull JetTypeReference typeReference) {
        return JsDescriptorUtils.getClassDescriptorForType(BindingUtils.getTypeByReference(context, typeReference));
    }

    @Nullable
    public static PropertyDescriptor getPropertyDescriptorForConstructorParameter(@NotNull BindingContext context, @NotNull JetParameter parameter) {
        return context.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
    }

    @Nullable
    public static JetProperty getPropertyForDescriptor(@NotNull BindingContext context, @NotNull PropertyDescriptor property) {
        PsiElement result = BindingContextUtils.descriptorToDeclaration(context, property);
        if (!(result instanceof JetProperty)) {
            return null;
        }
        return (JetProperty)result;
    }

    @NotNull
    public static DeclarationDescriptor getDescriptorForReferenceExpression(@NotNull BindingContext context, @NotNull JetReferenceExpression reference) {
        DeclarationDescriptor referencedDescriptor = BindingUtils.getNullableDescriptorForReferenceExpression(context, reference);
        assert (referencedDescriptor != null) : "Reference expression must reference a descriptor for reference " + reference.getText() + " at " + DiagnosticUtils.atLocation(reference);
        return referencedDescriptor;
    }

    @Nullable
    public static DeclarationDescriptor getNullableDescriptorForReferenceExpression(@NotNull BindingContext context, @NotNull JetReferenceExpression reference) {
        return context.get(BindingContext.REFERENCE_TARGET, reference);
    }

    public static boolean isNotAny(@NotNull DeclarationDescriptor superClassDescriptor) {
        return !superClassDescriptor.equals(JetStandardClasses.getAny());
    }

    @NotNull
    public static ResolvedCall<?> getResolvedCall(@NotNull BindingContext context, @NotNull JetExpression expression) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall = context.get(BindingContext.RESOLVED_CALL, expression);
        assert (resolvedCall != null) : "Must resolve to a call.";
        return resolvedCall;
    }

    @NotNull
    public static ResolvedCall<?> getResolvedCallForProperty(@NotNull BindingContext context, @NotNull JetExpression expression) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall = context.get(BindingContext.RESOLVED_CALL, expression);
        assert (resolvedCall != null) : "Must resolve to a call.";
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)resolvedCall).getVariableCall();
        }
        return resolvedCall;
    }

    @NotNull
    public static ResolvedCall<?> getResolvedCallForCallExpression(@NotNull BindingContext context, @NotNull JetCallExpression expression) {
        JetExpression calleeExpression = PsiUtils.getCallee(expression);
        return BindingUtils.getResolvedCall(context, calleeExpression);
    }

    public static boolean isVariableReassignment(@NotNull BindingContext context, @NotNull JetExpression expression) {
        Boolean result = context.get(BindingContext.VARIABLE_REASSIGNMENT, expression);
        assert (result != null);
        return result;
    }

    @Nullable
    public static FunctionDescriptor getFunctionDescriptorForOperationExpression(@NotNull BindingContext context, @NotNull JetOperationExpression expression) {
        DeclarationDescriptor descriptorForReferenceExpression = BindingUtils.getNullableDescriptorForReferenceExpression(context, expression.getOperationReference());
        if (descriptorForReferenceExpression == null) {
            return null;
        }
        assert (descriptorForReferenceExpression instanceof FunctionDescriptor) : "Operation should resolve to function descriptor.";
        return (FunctionDescriptor)descriptorForReferenceExpression;
    }

    @NotNull
    public static DeclarationDescriptor getDescriptorForElement(@NotNull BindingContext context, @NotNull PsiElement element) {
        DeclarationDescriptor descriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
        assert (descriptor != null) : element + " doesn't have a descriptor.";
        return descriptor;
    }

    @Nullable
    public static Object getCompileTimeValue(@NotNull BindingContext context, @NotNull JetExpression expression) {
        CompileTimeConstant<?> compileTimeValue = context.get(BindingContext.COMPILE_TIME_VALUE, expression);
        if (compileTimeValue != null) {
            return compileTimeValue.getValue();
        }
        return null;
    }

    @NotNull
    public static JetExpression getDefaultArgument(@NotNull BindingContext context, @NotNull ValueParameterDescriptor parameterDescriptor) {
        ValueParameterDescriptor descriptorWhichDeclaresDefaultValue = BindingUtils.getOriginalDescriptorWhichDeclaresDefaultValue(parameterDescriptor);
        JetParameter psiParameter = BindingUtils.getParameterForDescriptor(context, descriptorWhichDeclaresDefaultValue);
        JetExpression defaultValue = psiParameter.getDefaultValue();
        assert (defaultValue != null) : "No default value found in PSI.";
        return defaultValue;
    }

    private static ValueParameterDescriptor getOriginalDescriptorWhichDeclaresDefaultValue(@NotNull ValueParameterDescriptor parameterDescriptor) {
        ValueParameterDescriptor result = parameterDescriptor;
        assert (result.hasDefaultValue()) : "Unsupplied parameter must have default value.";
        while (!result.declaresDefaultValue()) {
            result = result.getOverriddenDescriptors().iterator().next();
        }
        return result;
    }

    @NotNull
    public static FunctionDescriptor getIteratorFunction(@NotNull BindingContext context, @NotNull JetExpression rangeExpression) {
        FunctionDescriptor functionDescriptor = context.get(BindingContext.LOOP_RANGE_ITERATOR, rangeExpression);
        assert (functionDescriptor != null) : "Range expression must have a descriptor for iterator function.";
        return functionDescriptor;
    }

    @NotNull
    public static FunctionDescriptor getNextFunction(@NotNull BindingContext context, @NotNull JetExpression rangeExpression) {
        FunctionDescriptor functionDescriptor = context.get(BindingContext.LOOP_RANGE_NEXT, rangeExpression);
        assert (functionDescriptor != null) : "Range expression must have a descriptor for next function.";
        return functionDescriptor;
    }

    @NotNull
    public static CallableDescriptor getHasNextCallable(@NotNull BindingContext context, @NotNull JetExpression rangeExpression) {
        CallableDescriptor hasNextDescriptor = context.get(BindingContext.LOOP_RANGE_HAS_NEXT, rangeExpression);
        assert (hasNextDescriptor != null) : "Range expression must have a descriptor for hasNext function or property.";
        return hasNextDescriptor;
    }

    @NotNull
    public static PropertyDescriptor getPropertyDescriptorForObjectDeclaration(@NotNull BindingContext context, @NotNull JetObjectDeclarationName name) {
        PropertyDescriptor propertyDescriptor = context.get(BindingContext.OBJECT_DECLARATION, name);
        assert (propertyDescriptor != null);
        return propertyDescriptor;
    }

    @NotNull
    public static Set<NamespaceDescriptor> getAllNonNativeNamespaceDescriptors(@NotNull BindingContext context, @NotNull List<JetFile> files) {
        HashSet<NamespaceDescriptor> descriptorSet = Sets.newHashSet();
        for (JetFile file : files) {
            NamespaceDescriptor namespaceDescriptor = BindingUtils.getNamespaceDescriptor(context, file);
            if (AnnotationsUtils.isPredefinedObject(namespaceDescriptor)) continue;
            descriptorSet.addAll(JsDescriptorUtils.getNamespaceDescriptorHierarchy(namespaceDescriptor));
        }
        return descriptorSet;
    }

    @NotNull
    public static JetType getTypeForExpression(@NotNull BindingContext context, @NotNull JetExpression expression) {
        JetType type = context.get(BindingContext.EXPRESSION_TYPE, expression);
        assert (type != null);
        return type;
    }

    @NotNull
    public static ResolvedCall<FunctionDescriptor> getResolvedCallForArrayAccess(@NotNull BindingContext context, @NotNull JetArrayAccessExpression arrayAccessExpression, boolean isGet) {
        ResolvedCall<FunctionDescriptor> resolvedCall = context.get(isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression);
        assert (resolvedCall != null);
        return resolvedCall;
    }

    public static ConstructorDescriptor getConstructor(@NotNull BindingContext bindingContext, @NotNull JetClassOrObject declaration) {
        ConstructorDescriptor primaryConstructor = BindingUtils.getClassDescriptor(bindingContext, declaration).getUnsubstitutedPrimaryConstructor();
        assert (primaryConstructor != null) : "Traits do not have initialize methods.";
        return primaryConstructor;
    }
}

