/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.PropertyAccessTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceAccessTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class ReferenceTranslator {
    private ReferenceTranslator() {
    }

    @NotNull
    public static JsExpression translateSimpleName(@NotNull JetSimpleNameExpression expression, @NotNull TranslationContext context) {
        return ReferenceTranslator.getAccessTranslator(expression, context).translateAsGet();
    }

    @NotNull
    public static JsExpression translateAsFQReference(@NotNull DeclarationDescriptor referencedDescriptor, @NotNull TranslationContext context) {
        JsNameRef qualifier = context.getQualifierForDescriptor(referencedDescriptor);
        if (qualifier == null) {
            return ReferenceTranslator.translateAsLocalNameReference(referencedDescriptor, context);
        }
        JsName referencedName = context.getNameForDescriptor(referencedDescriptor);
        return JsAstUtils.qualified(referencedName, qualifier);
    }

    @NotNull
    public static JsExpression translateAsLocalNameReference(@NotNull DeclarationDescriptor referencedDescriptor, @NotNull TranslationContext context) {
        return context.getNameForDescriptor(referencedDescriptor).makeRef();
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetSimpleNameExpression referenceExpression, @NotNull TranslationContext context) {
        return ReferenceTranslator.getAccessTranslator(referenceExpression, null, context);
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetSimpleNameExpression referenceExpression, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        if (PsiUtils.isBackingFieldReference(referenceExpression)) {
            return BackingFieldAccessTranslator.newInstance(referenceExpression, context);
        }
        if (PropertyAccessTranslator.canBePropertyAccess(referenceExpression, context)) {
            return PropertyAccessTranslator.newInstance(referenceExpression, receiver, CallType.NORMAL, context);
        }
        return ReferenceAccessTranslator.newInstance(referenceExpression, context);
    }
}

