/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedPropertyAccessTranslator;
import org.jetbrains.k2js.translate.reference.PropertyAccessTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class NativePropertyAccessTranslator
extends PropertyAccessTranslator {
    @Nullable
    private final JsExpression receiver;
    @NotNull
    private final PropertyDescriptor propertyDescriptor;

    NativePropertyAccessTranslator(@NotNull PropertyDescriptor descriptor, @Nullable JsExpression receiver, @NotNull TranslationContext context) {
        super(context);
        this.receiver = receiver;
        this.propertyDescriptor = descriptor.getOriginal();
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        return this.translateAsGet(this.getReceiver());
    }

    @Override
    @NotNull
    protected JsExpression translateAsGet(@Nullable JsExpression receiver) {
        JsName nativePropertyName = this.context().getNameForDescriptor(this.propertyDescriptor);
        if (receiver != null) {
            return JsAstUtils.qualified(nativePropertyName, receiver);
        }
        return nativePropertyName.makeRef();
    }

    @Override
    @NotNull
    protected JsExpression translateAsSet(@Nullable JsExpression receiver, @NotNull JsExpression setTo) {
        assert (receiver != null);
        return JsAstUtils.assignment(this.translateAsGet(receiver), setTo);
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        return this.translateAsSet(this.getReceiver(), setTo);
    }

    @Nullable
    private JsExpression getReceiver() {
        if (this.receiver != null) {
            return this.receiver;
        }
        assert (!this.propertyDescriptor.getReceiverParameter().exists()) : "Cant have native extension properties.";
        DeclarationDescriptor expectedThisDescriptor = JsDescriptorUtils.getExpectedThisDescriptor(this.propertyDescriptor);
        if (expectedThisDescriptor == null) {
            return null;
        }
        return TranslationUtils.getThisObject(this.context(), expectedThisDescriptor);
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        return new CachedPropertyAccessTranslator(this.getReceiver(), this, this.context());
    }
}

