/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.AbstractCallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.CallParameters;
import org.jetbrains.k2js.translate.reference.CallParametersResolver;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.k2js.translate.utils.mutator.Mutator;

public final class InlinedCallExpressionTranslator
extends AbstractCallExpressionTranslator {
    public static boolean shouldBeInlined(@NotNull JetCallExpression expression, @NotNull TranslationContext context) {
        ResolvedCall<?> resolvedCall = BindingUtils.getResolvedCallForCallExpression(context.bindingContext(), expression);
        Object descriptor = resolvedCall.getCandidateDescriptor();
        if (descriptor instanceof SimpleFunctionDescriptor) {
            return ((SimpleFunctionDescriptor)descriptor).isInline();
        }
        return false;
    }

    @NotNull
    public static JsExpression translate(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull CallType callType, @NotNull TranslationContext context) {
        return new InlinedCallExpressionTranslator(expression, receiver, callType, context).translate();
    }

    private InlinedCallExpressionTranslator(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull CallType callType, @NotNull TranslationContext context) {
        super(expression, receiver, callType, context);
    }

    @NotNull
    private JsExpression translate() {
        TranslationContext contextWithAllParametersAliased = this.createContextForInlining();
        JsBlock translatedBody = FunctionBodyTranslator.translateFunctionBody(this.getFunctionDescriptor(), this.getFunctionBody(), contextWithAllParametersAliased);
        TemporaryVariable temporaryVariable = contextWithAllParametersAliased.declareTemporary(this.program().getNullLiteral());
        JsNode mutatedBody = LastExpressionMutator.mutateLastExpression(translatedBody, new InlineFunctionMutator(temporaryVariable));
        this.context().addStatementToCurrentBlock(JsAstUtils.convertToBlock(mutatedBody));
        return temporaryVariable.reference();
    }

    @NotNull
    private JetFunction getFunctionBody() {
        return BindingUtils.getFunctionForDescriptor(this.bindingContext(), this.getFunctionDescriptor());
    }

    @NotNull
    private SimpleFunctionDescriptor getFunctionDescriptor() {
        CallableDescriptor descriptor = this.resolvedCall.getCandidateDescriptor().getOriginal();
        assert (descriptor instanceof SimpleFunctionDescriptor) : "Inlined functions should have descriptor of type SimpleFunctionDescriptor";
        return (SimpleFunctionDescriptor)descriptor;
    }

    @NotNull
    private TranslationContext createContextForInlining() {
        TranslationContext contextForInlining = this.context();
        contextForInlining = this.createContextWithAliasForThisExpression(contextForInlining);
        return this.createContextWithAliasesForParameters(contextForInlining);
    }

    @NotNull
    private TranslationContext createContextWithAliasesForParameters(@NotNull TranslationContext contextForInlining) {
        HashMap<DeclarationDescriptor, JsName> aliases = Maps.newHashMap();
        for (ValueParameterDescriptor parameterDescriptor : this.resolvedCall.getResultingDescriptor().getValueParameters()) {
            TemporaryVariable aliasForArgument = this.createAliasForArgument(parameterDescriptor);
            aliases.put(parameterDescriptor, aliasForArgument.name());
        }
        return contextForInlining.innerContextWithDescriptorsAliased(aliases);
    }

    @NotNull
    private TranslationContext createContextWithAliasForThisExpression(@NotNull TranslationContext contextForInlining) {
        JsExpression thisObject;
        TranslationContext contextWithAliasForThisExpression = contextForInlining;
        SimpleFunctionDescriptor functionDescriptor = this.getFunctionDescriptor();
        CallParameters callParameters = CallParametersResolver.resolveCallParameters(this.receiver, null, functionDescriptor, this.resolvedCall, contextForInlining);
        JsExpression receiver = callParameters.getReceiver();
        if (receiver != null) {
            contextWithAliasForThisExpression = this.contextWithAlias(contextWithAliasForThisExpression, receiver, JsDescriptorUtils.getExpectedReceiverDescriptor(functionDescriptor));
        }
        if ((thisObject = callParameters.getThisObject()) != null) {
            contextWithAliasForThisExpression = this.contextWithAlias(contextWithAliasForThisExpression, thisObject, JsDescriptorUtils.getExpectedThisDescriptor(functionDescriptor));
        }
        return contextWithAliasForThisExpression;
    }

    @NotNull
    private TranslationContext contextWithAlias(@NotNull TranslationContext contextWithAliasForThisExpression, @NotNull JsExpression aliasExpression, @Nullable DeclarationDescriptor descriptorToAlias) {
        TranslationContext newContext = contextWithAliasForThisExpression;
        TemporaryVariable aliasForReceiver = this.context().declareTemporary(aliasExpression);
        assert (descriptorToAlias != null);
        newContext = newContext.innerContextWithThisAliased(descriptorToAlias, aliasForReceiver.name());
        newContext.addStatementToCurrentBlock(aliasForReceiver.assignmentExpression().makeStmt());
        return newContext;
    }

    @NotNull
    private TemporaryVariable createAliasForArgument(@NotNull ValueParameterDescriptor parameterDescriptor) {
        ResolvedValueArgument actualArgument = this.resolvedCall.getValueArgumentsByIndex().get(parameterDescriptor.getIndex());
        JsExpression translatedArgument = this.translateArgument(parameterDescriptor, actualArgument);
        TemporaryVariable aliasForArgument = this.context().declareTemporary(translatedArgument);
        this.context().addStatementToCurrentBlock(aliasForArgument.assignmentExpression().makeStmt());
        return aliasForArgument;
    }

    @NotNull
    private JsExpression translateArgument(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument actualArgument) {
        List<JsExpression> translatedSingleArgument = this.translateSingleArgument(actualArgument, parameterDescriptor);
        assert (translatedSingleArgument.size() == 1) : "We always wrap varargs in kotlin calls.";
        return translatedSingleArgument.get(0);
    }

    @Override
    public boolean shouldWrapVarargInArray() {
        return true;
    }

    private static final class InlineFunctionMutator
    implements Mutator {
        @NotNull
        private final TemporaryVariable toAssignTo;

        private InlineFunctionMutator(@NotNull TemporaryVariable to) {
            this.toAssignTo = to;
        }

        @Override
        @NotNull
        public JsNode mutate(@NotNull JsNode node) {
            if (node instanceof JsReturn) {
                JsExpression returnedExpression = ((JsReturn)node).getExpr();
                return JsAstUtils.assignment(this.toAssignTo.name().makeRef(), returnedExpression);
            }
            return node;
        }
    }
}

