/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsConditional;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSafeQualifiedExpression;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public abstract class CallType
extends Enum<CallType> {
    public static final /* enum */ CallType SAFE = new CallType(){

        @Override
        @NotNull
        JsExpression constructCall(@Nullable JsExpression receiver, @NotNull CallConstructor constructor, @NotNull TranslationContext context) {
            assert (receiver != null);
            TemporaryVariable temporaryVariable = context.declareTemporary(receiver);
            JsBinaryOperation notNullCheck = TranslationUtils.notNullCheck(context, temporaryVariable.reference());
            JsNullLiteral nullLiteral = context.program().getNullLiteral();
            JsExpression methodCall = constructor.construct(temporaryVariable.reference());
            JsConditional callMethodIfNotNullElseNull = new JsConditional(notNullCheck, methodCall, nullLiteral);
            return AstUtil.newSequence(temporaryVariable.assignmentExpression(), callMethodIfNotNullElseNull);
        }
    };
    public static final /* enum */ CallType NORMAL = new CallType(){

        @Override
        @NotNull
        JsExpression constructCall(@Nullable JsExpression receiver, @NotNull CallConstructor constructor, @NotNull TranslationContext context) {
            return constructor.construct(receiver);
        }
    };
    private static final /* synthetic */ CallType[] $VALUES;

    public static CallType[] values() {
        return (CallType[])$VALUES.clone();
    }

    public static CallType valueOf(String name) {
        return Enum.valueOf(CallType.class, name);
    }

    @NotNull
    abstract JsExpression constructCall(@Nullable JsExpression var1, @NotNull CallConstructor var2, @NotNull TranslationContext var3);

    @NotNull
    public static CallType getCallTypeForQualifiedExpression(@NotNull JetQualifiedExpression expression) {
        if (expression instanceof JetSafeQualifiedExpression) {
            return SAFE;
        }
        assert (expression instanceof JetDotQualifiedExpression);
        return NORMAL;
    }

    static {
        $VALUES = new CallType[]{SAFE, NORMAL};
    }

    public static interface CallConstructor {
        @NotNull
        public JsExpression construct(@Nullable JsExpression var1);
    }
}

