/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.HasArguments;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.VariableAsFunctionResolvedCall;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.intrinsic.Intrinsic;
import org.jetbrains.k2js.translate.reference.CallParameters;
import org.jetbrains.k2js.translate.reference.CallParametersResolver;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class CallTranslator
extends AbstractTranslator {
    @NotNull
    private final List<JsExpression> arguments;
    @NotNull
    private final ResolvedCall<?> resolvedCall;
    @NotNull
    private final CallableDescriptor descriptor;
    @NotNull
    private final CallType callType;
    @NotNull
    private final CallParameters callParameters;

    CallTranslator(@Nullable JsExpression receiver, @Nullable JsExpression callee, @NotNull List<JsExpression> arguments, @NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall, @NotNull CallableDescriptor descriptorToCall, @NotNull CallType callType, @NotNull TranslationContext context) {
        super(context);
        this.arguments = arguments;
        this.resolvedCall = resolvedCall;
        this.callType = callType;
        this.descriptor = descriptorToCall;
        this.callParameters = CallParametersResolver.resolveCallParameters(receiver, callee, this.descriptor, resolvedCall, context);
    }

    @NotNull
    JsExpression translate() {
        if (this.isIntrinsic()) {
            return this.intrinsicInvocation();
        }
        if (this.isConstructor()) {
            return this.constructorCall();
        }
        if (this.isNativeExtensionFunctionCall()) {
            return this.nativeExtensionCall();
        }
        if (this.isExtensionFunctionLiteral()) {
            return this.extensionFunctionLiteralCall();
        }
        if (this.isExtensionFunction()) {
            return this.extensionFunctionCall();
        }
        if (this.isExpressionAsFunction()) {
            return this.expressionAsFunctionCall();
        }
        if (this.isInvoke()) {
            return this.invokeCall();
        }
        return this.methodCall(this.getThisObjectOrQualifier());
    }

    private boolean isInvoke() {
        return this.descriptor.getName().getName().equals("invoke");
    }

    @NotNull
    private JsExpression invokeCall() {
        JsInvocation callMethodInvocation = this.generateCallMethodInvocation();
        ArrayList<JsExpression> parameters = Lists.newArrayList(this.context().program().getNullLiteral());
        parameters.addAll(this.arguments);
        JsAstUtils.setArguments(callMethodInvocation, parameters);
        return callMethodInvocation;
    }

    private boolean isExpressionAsFunction() {
        return this.descriptor instanceof ExpressionAsFunctionDescriptor || this.resolvedCall instanceof VariableAsFunctionResolvedCall;
    }

    @NotNull
    private JsExpression expressionAsFunctionCall() {
        return this.methodCall(null);
    }

    private boolean isIntrinsic() {
        return this.context().intrinsics().isIntrinsic(this.descriptor);
    }

    @NotNull
    private JsExpression intrinsicInvocation() {
        assert (this.descriptor instanceof FunctionDescriptor);
        Intrinsic intrinsic = this.context().intrinsics().getFunctionIntrinsic((FunctionDescriptor)this.descriptor);
        return intrinsic.apply(this.callParameters.getThisOrReceiverOrNull(), this.arguments, this.context());
    }

    private boolean isConstructor() {
        return JsDescriptorUtils.isConstructorDescriptor(this.descriptor);
    }

    @NotNull
    private JsExpression constructorCall() {
        JsExpression constructorReference = this.translateAsFunctionWithNoThisObject(this.descriptor);
        JsExpression constructorCall = this.createConstructorCallExpression(constructorReference);
        assert (constructorCall instanceof HasArguments) : "Constructor call should be expression with arguments.";
        ((HasArguments)((Object)constructorCall)).getArguments().addAll(this.arguments);
        return constructorCall;
    }

    @NotNull
    private JsExpression createConstructorCallExpression(@NotNull JsExpression constructorReference) {
        if (this.context().isEcma5() && !AnnotationsUtils.isNativeObject(this.resolvedCall.getCandidateDescriptor())) {
            return AstUtil.newInvocation(constructorReference, new JsExpression[0]);
        }
        return new JsNew(constructorReference);
    }

    @NotNull
    private JsExpression translateAsFunctionWithNoThisObject(@NotNull DeclarationDescriptor descriptor) {
        return ReferenceTranslator.translateAsFQReference(descriptor, this.context());
    }

    private boolean isNativeExtensionFunctionCall() {
        return AnnotationsUtils.isNativeObject(this.descriptor) && this.isExtensionFunction();
    }

    @NotNull
    private JsExpression nativeExtensionCall() {
        return this.methodCall(this.callParameters.getReceiver());
    }

    private boolean isExtensionFunctionLiteral() {
        boolean isLiteral = this.isInvoke() || this.descriptor instanceof ExpressionAsFunctionDescriptor;
        return this.isExtensionFunction() && isLiteral;
    }

    @NotNull
    private JsExpression extensionFunctionLiteralCall() {
        return this.callType.constructCall(this.callParameters.getReceiver(), new CallType.CallConstructor(){

            @Override
            @NotNull
            public JsExpression construct(@Nullable JsExpression receiver) {
                assert (receiver != null) : "Could not be null for extensions";
                return CallTranslator.this.constructExtensionLiteralCall(receiver);
            }
        }, this.context());
    }

    @NotNull
    private JsExpression constructExtensionLiteralCall(@NotNull JsExpression realReceiver) {
        List<JsExpression> callArguments = this.generateExtensionCallArgumentList(realReceiver);
        JsInvocation callMethodInvocation = this.generateCallMethodInvocation();
        JsAstUtils.setArguments(callMethodInvocation, callArguments);
        return callMethodInvocation;
    }

    @NotNull
    private JsInvocation generateCallMethodInvocation() {
        JsNameRef callMethodNameRef = AstUtil.newQualifiedNameRef("call");
        JsInvocation callMethodInvocation = new JsInvocation();
        callMethodInvocation.setQualifier(callMethodNameRef);
        JsAstUtils.setQualifier(callMethodInvocation, this.callParameters.getFunctionReference());
        return callMethodInvocation;
    }

    private boolean isExtensionFunction() {
        boolean hasReceiver = this.resolvedCall.getReceiverArgument().exists();
        return hasReceiver;
    }

    @NotNull
    private JsExpression extensionFunctionCall() {
        return this.callType.constructCall(this.callParameters.getReceiver(), new CallType.CallConstructor(){

            @Override
            @NotNull
            public JsExpression construct(@Nullable JsExpression receiver) {
                assert (receiver != null) : "Could not be null for extensions";
                return CallTranslator.this.constructExtensionFunctionCall(receiver);
            }
        }, this.context());
    }

    @NotNull
    private JsExpression constructExtensionFunctionCall(@NotNull JsExpression receiver) {
        List<JsExpression> argumentList = this.generateExtensionCallArgumentList(receiver);
        JsExpression functionReference = this.callParameters.getFunctionReference();
        JsAstUtils.setQualifier(functionReference, this.getThisObjectOrQualifier());
        return JsAstUtils.newInvocation(functionReference, argumentList);
    }

    @NotNull
    private List<JsExpression> generateExtensionCallArgumentList(@NotNull JsExpression receiver) {
        ArrayList<JsExpression> argumentList = new ArrayList<JsExpression>();
        argumentList.add(receiver);
        argumentList.addAll(this.arguments);
        return argumentList;
    }

    @NotNull
    private JsExpression methodCall(@Nullable JsExpression receiver) {
        return this.callType.constructCall(receiver, new CallType.CallConstructor(){

            @Override
            @NotNull
            public JsExpression construct(@Nullable JsExpression receiver) {
                JsExpression qualifiedCallee = CallTranslator.this.getQualifiedCallee(receiver);
                if (CallTranslator.this.isEcma5PropertyAccess()) {
                    return CallTranslator.this.ecma5PropertyAccess(qualifiedCallee);
                }
                return JsAstUtils.newInvocation(qualifiedCallee, CallTranslator.this.arguments);
            }
        }, this.context());
    }

    @NotNull
    private JsExpression ecma5PropertyAccess(@NotNull JsExpression callee) {
        if (this.descriptor instanceof PropertyGetterDescriptor) {
            assert (this.arguments.isEmpty());
            return callee;
        }
        assert (this.descriptor instanceof PropertySetterDescriptor);
        assert (this.arguments.size() == 1);
        return JsAstUtils.assignment(callee, this.arguments.get(0));
    }

    private boolean isEcma5PropertyAccess() {
        return this.context().isEcma5() && this.descriptor instanceof PropertyAccessorDescriptor;
    }

    @NotNull
    private JsExpression getQualifiedCallee(@Nullable JsExpression receiver) {
        JsExpression callee = this.callParameters.getFunctionReference();
        if (receiver != null) {
            JsAstUtils.setQualifier(callee, receiver);
        }
        return callee;
    }

    @Nullable
    private JsExpression getThisObjectOrQualifier() {
        JsExpression thisObject = this.callParameters.getThisObject();
        if (thisObject != null) {
            return thisObject;
        }
        return this.context().getQualifierForDescriptor(this.descriptor);
    }
}

