/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.calls.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.VariableAsFunctionResolvedCall;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.AbstractCallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.InlinedCallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class CallExpressionTranslator
extends AbstractCallExpressionTranslator {
    private final boolean isNativeFunctionCall;

    @NotNull
    public static JsExpression translate(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull CallType callType, @NotNull TranslationContext context) {
        if (InlinedCallExpressionTranslator.shouldBeInlined(expression, context)) {
            return InlinedCallExpressionTranslator.translate(expression, receiver, callType, context);
        }
        return new CallExpressionTranslator(expression, receiver, callType, context).translate();
    }

    private CallExpressionTranslator(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull CallType callType, @NotNull TranslationContext context) {
        super(expression, receiver, callType, context);
        this.isNativeFunctionCall = AnnotationsUtils.isNativeObject(this.resolvedCall.getCandidateDescriptor());
    }

    @NotNull
    private JsExpression translate() {
        return CallBuilder.build(this.context()).receiver(this.getReceiver()).callee(this.getCalleeExpression()).args(this.translateArguments()).resolvedCall(this.getResolvedCall()).type(this.callType).translate();
    }

    @NotNull
    private ResolvedCall<?> getResolvedCall() {
        if (this.resolvedCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)this.resolvedCall).getFunctionCall();
        }
        return this.resolvedCall;
    }

    @Nullable
    private JsExpression getReceiver() {
        if (this.receiver != null) {
            return this.receiver;
        }
        return null;
    }

    @Nullable
    private JsExpression getCalleeExpression() {
        Object candidateDescriptor = this.resolvedCall.getCandidateDescriptor();
        if (candidateDescriptor instanceof ExpressionAsFunctionDescriptor) {
            return this.translateExpressionAsFunction();
        }
        if (this.resolvedCall instanceof VariableAsFunctionResolvedCall) {
            return this.translateVariableForVariableAsFunctionResolvedCall();
        }
        return null;
    }

    @NotNull
    private JsExpression translateVariableForVariableAsFunctionResolvedCall() {
        JetExpression callee = PsiUtils.getCallee(this.expression);
        if (callee instanceof JetSimpleNameExpression) {
            return ReferenceTranslator.getAccessTranslator((JetSimpleNameExpression)callee, this.receiver, this.context()).translateAsGet();
        }
        assert (this.receiver != null);
        return Translation.translateAsExpression(callee, this.context());
    }

    @NotNull
    private JsExpression translateExpressionAsFunction() {
        return Translation.translateAsExpression(PsiUtils.getCallee(this.expression), this.context());
    }

    @NotNull
    private List<JsExpression> translateArguments() {
        ArrayList<JsExpression> result = new ArrayList<JsExpression>();
        for (ValueParameterDescriptor parameterDescriptor : this.resolvedCall.getResultingDescriptor().getValueParameters()) {
            ResolvedValueArgument actualArgument = this.resolvedCall.getValueArgumentsByIndex().get(parameterDescriptor.getIndex());
            result.addAll(this.translateSingleArgument(actualArgument, parameterDescriptor));
        }
        return result;
    }

    @Override
    public boolean shouldWrapVarargInArray() {
        return !this.isNativeFunctionCall;
    }
}

