/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.reference.ArrayAccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.utils.TemporariesUtils;

public final class CachedArrayAccessTranslator
extends ArrayAccessTranslator
implements CachedAccessTranslator {
    @NotNull
    private final TemporaryVariable arrayExpression;
    @NotNull
    private final List<TemporaryVariable> indexExpressions;

    CachedArrayAccessTranslator(@NotNull JetArrayAccessExpression expression, @NotNull TranslationContext context) {
        super(expression, context);
        this.arrayExpression = context.declareTemporary(this.translateArrayExpression());
        this.indexExpressions = TemporariesUtils.fromExpressionList(this.translateIndexExpressions(), context);
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        return this.translateAsGet(this.arrayExpression.reference(), TemporariesUtils.toExpressionList(this.indexExpressions));
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        return this.translateAsSet(this.arrayExpression.reference(), TemporariesUtils.toExpressionList(this.indexExpressions), setTo);
    }

    @Override
    @NotNull
    public List<TemporaryVariable> declaredTemporaries() {
        ArrayList<TemporaryVariable> result = Lists.newArrayList();
        result.add(this.arrayExpression);
        result.addAll(this.indexExpressions);
        return result;
    }
}

