/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.reference.CachedArrayAccessTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public class ArrayAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    @NotNull
    private final JetArrayAccessExpression expression;

    static ArrayAccessTranslator newInstance(@NotNull JetArrayAccessExpression expression, @NotNull TranslationContext context) {
        return new ArrayAccessTranslator(expression, context);
    }

    protected ArrayAccessTranslator(@NotNull JetArrayAccessExpression expression, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        return this.translateAsGet(this.translateArrayExpression(), this.translateIndexExpressions());
    }

    @NotNull
    protected JsExpression translateAsGet(@NotNull JsExpression arrayExpression, @NotNull List<JsExpression> indexExpression) {
        return this.translateAsMethodCall(arrayExpression, indexExpression, true);
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        return this.translateAsSet(this.translateArrayExpression(), this.translateIndexExpressions(), setTo);
    }

    @NotNull
    protected JsExpression translateAsSet(@NotNull JsExpression arrayExpression, @NotNull List<JsExpression> indexExpressions, @NotNull JsExpression toSetTo) {
        ArrayList<JsExpression> arguments = Lists.newArrayList(indexExpressions);
        arguments.add(toSetTo);
        return this.translateAsMethodCall(arrayExpression, arguments, false);
    }

    @NotNull
    private JsExpression translateAsMethodCall(@NotNull JsExpression arrayExpression, @NotNull List<JsExpression> arguments, boolean isGetter) {
        return CallBuilder.build(this.context()).receiver(arrayExpression).args(arguments).resolvedCall(BindingUtils.getResolvedCallForArrayAccess(this.bindingContext(), this.expression, isGetter)).translate();
    }

    @NotNull
    protected List<JsExpression> translateIndexExpressions() {
        return TranslationUtils.translateExpressionList(this.context(), this.expression.getIndexExpressions());
    }

    @NotNull
    protected JsExpression translateArrayExpression() {
        return Translation.translateAsExpression(this.expression.getArrayExpression(), this.context());
    }

    @Override
    @NotNull
    public CachedAccessTranslator getCached() {
        return new CachedArrayAccessTranslator(this.expression, this.context());
    }
}

