/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.calls.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.VarargValueArgument;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public abstract class AbstractCallExpressionTranslator
extends AbstractTranslator {
    @NotNull
    protected final JetCallExpression expression;
    @NotNull
    protected final ResolvedCall<?> resolvedCall;
    @Nullable
    protected final JsExpression receiver;
    @NotNull
    protected final CallType callType;

    protected AbstractCallExpressionTranslator(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull CallType type, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression;
        this.resolvedCall = BindingUtils.getResolvedCallForCallExpression(this.bindingContext(), expression);
        this.receiver = receiver;
        this.callType = type;
    }

    public abstract boolean shouldWrapVarargInArray();

    @NotNull
    protected List<JsExpression> translateSingleArgument(@NotNull ResolvedValueArgument actualArgument, @NotNull ValueParameterDescriptor parameterDescriptor) {
        List<ValueArgument> valueArguments = actualArgument.getArguments();
        if (actualArgument instanceof VarargValueArgument) {
            return this.translateVarargArgument(valueArguments);
        }
        if (actualArgument instanceof DefaultValueArgument) {
            JetExpression defaultArgument = BindingUtils.getDefaultArgument(this.bindingContext(), parameterDescriptor);
            return Arrays.asList(Translation.translateAsExpression(defaultArgument, this.context()));
        }
        assert (actualArgument instanceof ExpressionValueArgument);
        assert (valueArguments.size() == 1);
        JetExpression argumentExpression = valueArguments.get(0).getArgumentExpression();
        assert (argumentExpression != null);
        return Arrays.asList(Translation.translateAsExpression(argumentExpression, this.context()));
    }

    @NotNull
    private List<JsExpression> translateVarargArgument(@NotNull List<ValueArgument> arguments) {
        ArrayList<JsExpression> translatedArgs = Lists.newArrayList();
        for (ValueArgument argument : arguments) {
            JetExpression argumentExpression = argument.getArgumentExpression();
            assert (argumentExpression != null);
            translatedArgs.add(Translation.translateAsExpression(argumentExpression, this.context()));
        }
        if (this.shouldWrapVarargInArray()) {
            return AbstractCallExpressionTranslator.wrapInArrayLiteral(translatedArgs);
        }
        return translatedArgs;
    }

    @NotNull
    private static List<JsExpression> wrapInArrayLiteral(@NotNull List<JsExpression> translatedArgs) {
        JsArrayLiteral argsWrappedInArray = new JsArrayLiteral();
        argsWrappedInArray.getExpressions().addAll(translatedArgs);
        return Arrays.asList(argsWrappedInArray);
    }
}

