/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsConditional;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.operation.IncrementTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class UnaryOperationTranslator {
    private UnaryOperationTranslator() {
    }

    @NotNull
    public static JsExpression translate(@NotNull JetUnaryExpression expression, @NotNull TranslationContext context) {
        if (UnaryOperationTranslator.isExclExcl(expression)) {
            return UnaryOperationTranslator.translateExclExclOperator(expression, context);
        }
        if (IncrementTranslator.isIncrement(expression)) {
            return IncrementTranslator.translate(expression, context);
        }
        return UnaryOperationTranslator.translateAsCall(expression, context);
    }

    private static boolean isExclExcl(@NotNull JetUnaryExpression expression) {
        return PsiUtils.getOperationToken(expression).equals(JetTokens.EXCLEXCL);
    }

    @NotNull
    private static JsExpression translateExclExclOperator(@NotNull JetUnaryExpression expression, @NotNull TranslationContext context) {
        JsExpression translatedExpression = Translation.translateAsExpression(PsiUtils.getBaseExpression(expression), context);
        JsBinaryOperation notNullCheck = TranslationUtils.notNullCheck(context, translatedExpression);
        return new JsConditional(notNullCheck, translatedExpression, context.namer().throwNPEFunctionCall());
    }

    @NotNull
    private static JsExpression translateAsCall(@NotNull JetUnaryExpression expression, @NotNull TranslationContext context) {
        return CallBuilder.build(context).receiver(TranslationUtils.translateBaseExpression(context, expression)).args(Collections.<JsExpression>emptyList()).resolvedCall(BindingUtils.getResolvedCall(context.bindingContext(), expression.getOperationReference())).type(CallType.NORMAL).translate();
    }
}

