/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.operation.AssignmentTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class OverloadedAssignmentTranslator
extends AssignmentTranslator {
    @NotNull
    private final JsNameRef operationReference;

    @NotNull
    public static JsExpression doTranslate(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        return new OverloadedAssignmentTranslator(expression, context).translate();
    }

    private OverloadedAssignmentTranslator(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        super(expression, context);
        this.operationReference = TranslationUtils.getMethodReferenceForOverloadedOperation(context, expression);
    }

    @NotNull
    private JsExpression translate() {
        if (this.isVariableReassignment) {
            return this.reassignment();
        }
        return this.overloadedMethodInvocation();
    }

    @NotNull
    private JsExpression reassignment() {
        return this.accessTranslator.translateAsSet(this.overloadedMethodInvocation());
    }

    @NotNull
    private JsExpression overloadedMethodInvocation() {
        JsAstUtils.setQualifier(this.operationReference, this.accessTranslator.translateAsGet());
        return AstUtil.newInvocation(this.operationReference, this.right);
    }
}

