/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.operation.IntrinsicIncrementTranslator;
import org.jetbrains.k2js.translate.operation.OverloadedIncrementTranslator;
import org.jetbrains.k2js.translate.reference.AccessTranslationUtils;
import org.jetbrains.k2js.translate.reference.CachedAccessTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TemporariesUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public abstract class IncrementTranslator
extends AbstractTranslator {
    @NotNull
    protected final JetUnaryExpression expression;
    @NotNull
    protected final CachedAccessTranslator accessTranslator;

    public static boolean isIncrement(@NotNull JetUnaryExpression expression) {
        return OperatorConventions.INCREMENT_OPERATIONS.contains(PsiUtils.getOperationToken(expression));
    }

    @NotNull
    public static JsExpression translate(@NotNull JetUnaryExpression expression, @NotNull TranslationContext context) {
        if (TranslationUtils.isIntrinsicOperation(context, expression)) {
            return IntrinsicIncrementTranslator.doTranslate(expression, context);
        }
        return new OverloadedIncrementTranslator(expression, context).translateIncrementExpression();
    }

    protected IncrementTranslator(@NotNull JetUnaryExpression expression, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression;
        JetExpression baseExpression = PsiUtils.getBaseExpression(expression);
        this.accessTranslator = AccessTranslationUtils.getCachedAccessTranslator(baseExpression, this.context());
    }

    @NotNull
    protected JsExpression translateIncrementExpression() {
        return this.withTemporariesInitialized(this.doTranslateIncrementExpression());
    }

    @NotNull
    private JsExpression doTranslateIncrementExpression() {
        if (PsiUtils.isPrefix(this.expression)) {
            return this.asPrefix();
        }
        return this.asPostfix();
    }

    @NotNull
    private JsExpression asPrefix() {
        JsExpression getExpression = this.accessTranslator.translateAsGet();
        JsExpression reassignment = this.variableReassignment(getExpression);
        JsExpression getNewValue = this.accessTranslator.translateAsGet();
        return AstUtil.newSequence(reassignment, getNewValue);
    }

    @NotNull
    private JsExpression asPostfix() {
        TemporaryVariable t1 = this.context().declareTemporary(this.accessTranslator.translateAsGet());
        TemporaryVariable t2 = this.context().declareTemporary(t1.reference());
        JsExpression variableReassignment = this.variableReassignment(t1.reference());
        return AstUtil.newSequence(t1.assignmentExpression(), t2.assignmentExpression(), variableReassignment, t2.reference());
    }

    @NotNull
    private JsExpression variableReassignment(@NotNull JsExpression toCallMethodUpon) {
        JsExpression overloadedMethodCallOnPropertyGetter = this.operationExpression(toCallMethodUpon);
        return this.accessTranslator.translateAsSet(overloadedMethodCallOnPropertyGetter);
    }

    @NotNull
    private JsExpression withTemporariesInitialized(@NotNull JsExpression expression) {
        List<TemporaryVariable> temporaries = this.accessTranslator.declaredTemporaries();
        ArrayList<JsExpression> expressions = Lists.newArrayList(TemporariesUtils.temporariesInitialization(temporaries));
        expressions.add(expression);
        return JsAstUtils.newSequence(expressions);
    }

    @NotNull
    abstract JsExpression operationExpression(@NotNull JsExpression var1);
}

