/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.intrinsic.CompareToIntrinsic;
import org.jetbrains.k2js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class CompareToTranslator
extends AbstractTranslator {
    @NotNull
    private final JetBinaryExpression expression;
    @NotNull
    private final FunctionDescriptor descriptor;

    public static boolean isCompareToCall(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        FunctionDescriptor operationDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(context.bindingContext(), expression);
        if (operationDescriptor == null) {
            return false;
        }
        return JsDescriptorUtils.isCompareTo(operationDescriptor);
    }

    @NotNull
    public static JsExpression translate(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        return new CompareToTranslator(expression, context).translate();
    }

    private CompareToTranslator(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression;
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(context.bindingContext(), expression);
        assert (functionDescriptor != null) : "CompareTo should always have a descriptor";
        this.descriptor = functionDescriptor;
        assert (OperatorConventions.COMPARISON_OPERATIONS.contains(PsiUtils.getOperationToken(expression)));
    }

    @NotNull
    private JsExpression translate() {
        if (TranslationUtils.isIntrinsicOperation(this.context(), this.expression)) {
            return this.intrinsicCompareTo();
        }
        return this.overloadedCompareTo();
    }

    @NotNull
    private JsExpression overloadedCompareTo() {
        JsBinaryOperator correspondingOperator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(this.expression));
        JsExpression methodCall = BinaryOperationTranslator.translateAsOverloadedCall(this.expression, this.context());
        return new JsBinaryOperation(correspondingOperator, methodCall, TranslationUtils.zeroLiteral(this.context()));
    }

    @NotNull
    private JsExpression intrinsicCompareTo() {
        CompareToIntrinsic intrinsic = this.context().intrinsics().getCompareToIntrinsic(this.descriptor);
        intrinsic.setComparisonToken((JetToken)this.expression.getOperationToken());
        return TranslationUtils.applyIntrinsicToBinaryExpression(this.context(), intrinsic, this.expression);
    }
}

