/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsConditional;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.intrinsic.EqualsIntrinsic;
import org.jetbrains.k2js.translate.operation.AssignmentTranslator;
import org.jetbrains.k2js.translate.operation.CompareToTranslator;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class BinaryOperationTranslator
extends AbstractTranslator {
    @NotNull
    private final JetBinaryExpression expression;
    @Nullable
    private final FunctionDescriptor operationDescriptor;

    @NotNull
    public static JsExpression translate(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        return new BinaryOperationTranslator(expression, context).translate();
    }

    @NotNull
    static JsExpression translateAsOverloadedCall(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        return new BinaryOperationTranslator(expression, context).translateAsOverloadedBinaryOperation();
    }

    private BinaryOperationTranslator(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression;
        this.operationDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(this.bindingContext(), expression);
    }

    @NotNull
    private JsExpression translate() {
        if (BinaryOperationTranslator.isElvisOperator(this.expression)) {
            return this.translateAsElvisOperator(this.expression);
        }
        if (AssignmentTranslator.isAssignmentOperator(this.expression)) {
            return AssignmentTranslator.translate(this.expression, this.context());
        }
        if (this.isNotOverloadable()) {
            return this.translateAsUnOverloadableBinaryOperation();
        }
        if (CompareToTranslator.isCompareToCall(this.expression, this.context())) {
            return CompareToTranslator.translate(this.expression, this.context());
        }
        assert (this.operationDescriptor != null) : "Overloadable operations must have not null descriptor";
        if (JsDescriptorUtils.isEquals(this.operationDescriptor)) {
            return this.translateAsEqualsCall();
        }
        return this.translateAsOverloadedBinaryOperation();
    }

    private static boolean isElvisOperator(@NotNull JetBinaryExpression expression) {
        return PsiUtils.getOperationToken(expression).equals(JetTokens.ELVIS);
    }

    @NotNull
    private JsExpression translateAsElvisOperator(@NotNull JetBinaryExpression expression) {
        JsExpression translatedLeft = TranslationUtils.translateLeftExpression(this.context(), expression);
        JsExpression translatedRight = TranslationUtils.translateRightExpression(this.context(), expression);
        JsBinaryOperation leftIsNotNull = JsAstUtils.inequality(translatedLeft, this.program().getNullLiteral());
        return new JsConditional(leftIsNotNull, translatedLeft, translatedRight);
    }

    private boolean isNotOverloadable() {
        return this.operationDescriptor == null;
    }

    @NotNull
    private JsExpression translateAsEqualsCall() {
        assert (this.operationDescriptor != null) : "Equals operation must resolve to descriptor.";
        EqualsIntrinsic intrinsic = this.context().intrinsics().getEqualsIntrinsic(this.operationDescriptor);
        intrinsic.setNegated(this.expression.getOperationToken().equals(JetTokens.EXCLEQ));
        return TranslationUtils.applyIntrinsicToBinaryExpression(this.context(), intrinsic, this.expression);
    }

    @NotNull
    private JsExpression translateAsUnOverloadableBinaryOperation() {
        JetToken token = PsiUtils.getOperationToken(this.expression);
        JsBinaryOperator operator = OperatorTable.getBinaryOperator(token);
        assert (OperatorConventions.NOT_OVERLOADABLE.contains(token));
        JsExpression left = TranslationUtils.translateLeftExpression(this.context(), this.expression);
        JsExpression right = TranslationUtils.translateRightExpression(this.context(), this.expression);
        return new JsBinaryOperation(operator, left, right);
    }

    @NotNull
    private JsExpression translateAsOverloadedBinaryOperation() {
        CallBuilder callBuilder = this.setReceiverAndArguments();
        ResolvedCall<?> resolvedCall1 = BindingUtils.getResolvedCall(this.bindingContext(), this.expression.getOperationReference());
        JsExpression result = callBuilder.resolvedCall(resolvedCall1).type(CallType.NORMAL).translate();
        return this.mayBeWrapWithNegation(result);
    }

    @NotNull
    private CallBuilder setReceiverAndArguments() {
        CallBuilder callBuilder = CallBuilder.build(this.context());
        JsExpression leftExpression = TranslationUtils.translateLeftExpression(this.context(), this.expression);
        JsExpression rightExpression = TranslationUtils.translateRightExpression(this.context(), this.expression);
        if (PsiUtils.isInOrNotInOperation(this.expression)) {
            return callBuilder.receiver(rightExpression).args(leftExpression);
        }
        return callBuilder.receiver(leftExpression).args(rightExpression);
    }

    @NotNull
    private JsExpression mayBeWrapWithNegation(@NotNull JsExpression result) {
        if (PsiUtils.isNotInOperation(this.expression)) {
            return JsAstUtils.not(result);
        }
        return result;
    }
}

