/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.tuple;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.Intrinsic;

public final class TupleAccessIntrinsic
implements Intrinsic {
    private final int elementIndex;

    public TupleAccessIntrinsic(int elementIndex) {
        this.elementIndex = elementIndex;
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
        assert (arguments.isEmpty()) : "Tuple access expression should not have any arguments.";
        return AstUtil.newArrayAccess(receiver, context.program().getNumberLiteral(this.elementIndex));
    }
}

