/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.primitive;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.Intrinsic;
import org.jetbrains.k2js.translate.operation.OperatorTable;

public final class PrimitiveUnaryOperationIntrinsic
implements Intrinsic {
    @NotNull
    private final JsUnaryOperator operator;

    @NotNull
    public static PrimitiveUnaryOperationIntrinsic newInstance(@NotNull JetToken token) {
        JsUnaryOperator operator = OperatorTable.getUnaryOperator(token);
        return new PrimitiveUnaryOperationIntrinsic(operator);
    }

    private PrimitiveUnaryOperationIntrinsic(@NotNull JsUnaryOperator operator) {
        this.operator = operator;
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
        assert (receiver != null);
        assert (arguments.size() == 0) : "Unary operator should not have arguments.";
        return new JsPrefixOperation(this.operator, receiver);
    }
}

