/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.primitive;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.HasArguments;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBooleanLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.Intrinsic;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class PrimitiveRangeToIntrinsic
implements Intrinsic {
    @NotNull
    public static PrimitiveRangeToIntrinsic newInstance() {
        return new PrimitiveRangeToIntrinsic();
    }

    private PrimitiveRangeToIntrinsic() {
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression rangeStart, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
        assert (arguments.size() == 1) : "RangeTo must have one argument.";
        assert (rangeStart != null);
        JsExpression rangeEnd = arguments.get(0);
        JsBinaryOperation rangeSize = JsAstUtils.sum(JsAstUtils.subtract(rangeEnd, rangeStart), context.program().getNumberLiteral(1.0));
        JsNameRef expr = AstUtil.newQualifiedNameRef("Kotlin.NumberRange");
        JsExpression numberRangeConstructorInvocation = context.isEcma5() ? AstUtil.newInvocation(expr, new JsExpression[0]) : new JsNew(expr);
        JsBooleanLiteral isRangeReversed = context.program().getFalseLiteral();
        JsAstUtils.setArguments((HasArguments)((Object)numberRangeConstructorInvocation), rangeStart, rangeSize, isRangeReversed);
        return numberRangeConstructorInvocation;
    }
}

