/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.primitive;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.EqualsIntrinsic;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class PrimitiveEqualsIntrinsic
extends EqualsIntrinsic {
    @NotNull
    public static PrimitiveEqualsIntrinsic newInstance() {
        return new PrimitiveEqualsIntrinsic();
    }

    private PrimitiveEqualsIntrinsic() {
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
        assert (arguments.size() == 1) : "Equals operation should have one argument";
        assert (receiver != null);
        if (this.isNegated()) {
            return JsAstUtils.inequality(receiver, arguments.get(0));
        }
        return JsAstUtils.equality(receiver, arguments.get(0));
    }
}

