/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.primitive;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.Intrinsic;
import org.jetbrains.k2js.translate.operation.OperatorTable;

public final class PrimitiveBinaryOperationIntrinsic
implements Intrinsic {
    @NotNull
    private final JsBinaryOperator operator;

    @NotNull
    public static PrimitiveBinaryOperationIntrinsic newInstance(@NotNull JetToken token) {
        JsBinaryOperator operator = OperatorTable.getBinaryOperator(token);
        return new PrimitiveBinaryOperationIntrinsic(operator);
    }

    @NotNull
    public static PrimitiveBinaryOperationIntrinsic newInstance(@NotNull JsBinaryOperator operator) {
        return new PrimitiveBinaryOperationIntrinsic(operator);
    }

    private PrimitiveBinaryOperationIntrinsic(@NotNull JsBinaryOperator operator) {
        this.operator = operator;
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
        assert (arguments.size() == 1) : "Binary operator should have a receiver and one argument";
        return new JsBinaryOperation(this.operator, receiver, arguments.get(0));
    }
}

