/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.ImmutableBiMap;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.intrinsic.BuiltInFunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.BuiltInPropertyIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.CallStandardMethodIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.CompareToIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.EqualsIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.Intrinsic;
import org.jetbrains.k2js.translate.intrinsic.ReturnReceiverIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.array.ArrayGetIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.array.ArraySetIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.primitive.PrimitiveBinaryOperationIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.primitive.PrimitiveCompareToIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.primitive.PrimitiveEqualsIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.primitive.PrimitiveRangeToIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.primitive.PrimitiveUnaryOperationIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.string.CharAtIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.tuple.TupleAccessIntrinsic;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class Intrinsics {
    @NotNull
    private final Map<FunctionDescriptor, Intrinsic> functionIntrinsics = new HashMap<FunctionDescriptor, Intrinsic>();
    @NotNull
    private final Map<FunctionDescriptor, EqualsIntrinsic> equalsIntrinsics = new HashMap<FunctionDescriptor, EqualsIntrinsic>();
    @NotNull
    private final Map<FunctionDescriptor, CompareToIntrinsic> compareToIntrinsics = new HashMap<FunctionDescriptor, CompareToIntrinsic>();
    @NotNull
    private final Intrinsic lengthPropertyIntrinsic = new BuiltInPropertyIntrinsic("length");
    @NotNull
    private final JetStandardLibrary library;

    public static Intrinsics standardLibraryIntrinsics(@NotNull JetStandardLibrary library) {
        return new Intrinsics(library);
    }

    private Intrinsics(@NotNull JetStandardLibrary library) {
        this.library = library;
        this.declareOperatorIntrinsics();
        this.declareStringIntrinsics();
        this.declareTuplesIntrinsics();
        this.declareArrayIntrinsics();
        this.declareBooleanIntrinsics();
        FunctionDescriptor intToDouble = JsDescriptorUtils.getFunctionByName(library.getInt().getDefaultType().getMemberScope(), Name.identifier("toDouble"));
        this.functionIntrinsics.put(intToDouble, ReturnReceiverIntrinsic.INSTANCE);
        FunctionDescriptor doubleToInt = JsDescriptorUtils.getFunctionByName(library.getDouble().getDefaultType().getMemberScope(), Name.identifier("toInt"));
        this.functionIntrinsics.put(doubleToInt, new CallStandardMethodIntrinsic("Math.floor", true, 0));
        FunctionDescriptor toStringFunction = JsDescriptorUtils.getFunctionByName(library.getLibraryScope(), Name.identifier("toString"));
        this.functionIntrinsics.put(toStringFunction, new BuiltInFunctionIntrinsic("toString"));
    }

    private void declareBooleanIntrinsics() {
        FunctionDescriptor andFunction = JsDescriptorUtils.getFunctionByName(this.library.getBoolean().getDefaultType().getMemberScope(), Name.identifier("and"));
        this.functionIntrinsics.put(andFunction, PrimitiveBinaryOperationIntrinsic.newInstance(JetTokens.ANDAND));
        FunctionDescriptor orFunction = JsDescriptorUtils.getFunctionByName(this.library.getBoolean().getDefaultType().getMemberScope(), Name.identifier("or"));
        this.functionIntrinsics.put(orFunction, PrimitiveBinaryOperationIntrinsic.newInstance(JetTokens.OROR));
        FunctionDescriptor notFunction = JsDescriptorUtils.getFunctionByName(this.library.getBoolean().getDefaultType().getMemberScope(), Name.identifier("not"));
        this.functionIntrinsics.put(notFunction, PrimitiveUnaryOperationIntrinsic.newInstance(JetTokens.EXCL));
        FunctionDescriptor xorFunction = JsDescriptorUtils.getFunctionByName(this.library.getBoolean().getDefaultType().getMemberScope(), Name.identifier("xor"));
        this.functionIntrinsics.put(xorFunction, PrimitiveBinaryOperationIntrinsic.newInstance(JsBinaryOperator.BIT_XOR));
    }

    @NotNull
    public Intrinsic getLengthPropertyIntrinsic() {
        return this.lengthPropertyIntrinsic;
    }

    private void declareTuplesIntrinsics() {
        for (int tupleSize = 0; tupleSize <= 22; ++tupleSize) {
            this.declareTupleIntrinsics(tupleSize);
        }
    }

    private void declareArrayIntrinsics() {
        List<JetType> arrayTypes = this.getLibraryArrayTypes();
        for (JetType arrayType : arrayTypes) {
            this.declareIntrinsicsForArrayType(arrayType);
        }
        this.declareNullConstructorIntrinsic();
    }

    private void declareNullConstructorIntrinsic() {
        FunctionDescriptor nullArrayConstructor = this.library.getLibraryScope().getFunctions(Name.identifier("arrayOfNulls")).iterator().next();
        this.functionIntrinsics.put(nullArrayConstructor, new CallStandardMethodIntrinsic("Kotlin.nullArray", false, 1));
    }

    private void declareIntrinsicsForArrayType(@NotNull JetType arrayType) {
        JetScope arrayMemberScope = arrayType.getMemberScope();
        FunctionDescriptor setFunction = JsDescriptorUtils.getFunctionByName(arrayMemberScope, Name.identifier("set"));
        this.functionIntrinsics.put(setFunction, ArraySetIntrinsic.INSTANCE);
        FunctionDescriptor getFunction = JsDescriptorUtils.getFunctionByName(arrayMemberScope, Name.identifier("get"));
        this.functionIntrinsics.put(getFunction, ArrayGetIntrinsic.INSTANCE);
        PropertyDescriptor sizeProperty = JsDescriptorUtils.getPropertyByName(arrayMemberScope, Name.identifier("size"));
        this.functionIntrinsics.put(sizeProperty.getGetter(), this.lengthPropertyIntrinsic);
        PropertyDescriptor indicesProperty = JsDescriptorUtils.getPropertyByName(arrayMemberScope, Name.identifier("indices"));
        this.functionIntrinsics.put(indicesProperty.getGetter(), new CallStandardMethodIntrinsic("Kotlin.arrayIndices", true, 0));
        FunctionDescriptor iteratorFunction = JsDescriptorUtils.getFunctionByName(arrayMemberScope, Name.identifier("iterator"));
        this.functionIntrinsics.put(iteratorFunction, new CallStandardMethodIntrinsic("Kotlin.arrayIterator", true, 0));
        ConstructorDescriptor arrayConstructor = ((ClassDescriptor)arrayMemberScope.getContainingDeclaration()).getConstructors().iterator().next();
        this.functionIntrinsics.put(arrayConstructor, new CallStandardMethodIntrinsic("Kotlin.arrayFromFun", false, 2));
    }

    private List<JetType> getLibraryArrayTypes() {
        ArrayList<JetType> arrayTypes = Lists.newArrayList();
        for (PrimitiveType type : PrimitiveType.values()) {
            arrayTypes.add(this.library.getPrimitiveArrayJetType(type));
        }
        arrayTypes.add(this.library.getArray().getDefaultType());
        return arrayTypes;
    }

    private void declareTupleIntrinsics(int tupleSize) {
        JetScope libraryScope = this.library.getLibraryScope();
        assert (libraryScope != null);
        ClassifierDescriptor tupleDescriptor = libraryScope.getClassifier(Name.identifier("Tuple" + tupleSize));
        assert (tupleDescriptor != null);
        this.declareTupleIntrinsicAccessors(tupleDescriptor, tupleSize);
    }

    private void declareStringIntrinsics() {
        PropertyDescriptor stringLengthProperty = JsDescriptorUtils.getPropertyByName(this.library.getString().getDefaultType().getMemberScope(), Name.identifier("length"));
        this.functionIntrinsics.put(stringLengthProperty.getGetter(), this.lengthPropertyIntrinsic);
        PropertyDescriptor charSequenceLengthProperty = JsDescriptorUtils.getPropertyByName(this.library.getCharSequence().getDefaultType().getMemberScope(), Name.identifier("length"));
        this.functionIntrinsics.put(charSequenceLengthProperty.getGetter(), this.lengthPropertyIntrinsic);
        FunctionDescriptor getFunction = JsDescriptorUtils.getFunctionByName(this.library.getString().getDefaultType().getMemberScope(), Name.identifier("get"));
        this.functionIntrinsics.put(getFunction, CharAtIntrinsic.INSTANCE);
    }

    private void declareTupleIntrinsicAccessors(@NotNull ClassifierDescriptor tupleDescriptor, int tupleSize) {
        for (int elementIndex = 0; elementIndex < tupleSize; ++elementIndex) {
            Name accessorName = Name.identifier("_" + (elementIndex + 1));
            PropertyDescriptor propertyDescriptor = JsDescriptorUtils.getPropertyByName(tupleDescriptor.getDefaultType().getMemberScope(), accessorName);
            this.functionIntrinsics.put(propertyDescriptor.getGetter(), new TupleAccessIntrinsic(elementIndex));
        }
    }

    private void declareOperatorIntrinsics() {
        IntrinsicDeclarationVisitor visitor = new IntrinsicDeclarationVisitor();
        for (DeclarationDescriptor descriptor : this.library.getLibraryScope().getAllDescriptors()) {
            descriptor.accept(visitor, null);
        }
    }

    public boolean isIntrinsic(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor instanceof FunctionDescriptor) {
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor.getOriginal();
            return this.equalsIntrinsics.containsKey(functionDescriptor) || this.compareToIntrinsics.containsKey(functionDescriptor) || this.functionIntrinsics.containsKey(functionDescriptor);
        }
        return false;
    }

    @NotNull
    public Intrinsic getFunctionIntrinsic(@NotNull FunctionDescriptor descriptor) {
        return this.functionIntrinsics.get(descriptor.getOriginal());
    }

    @NotNull
    public CompareToIntrinsic getCompareToIntrinsic(@NotNull FunctionDescriptor descriptor) {
        return this.compareToIntrinsics.get(descriptor.getOriginal());
    }

    @NotNull
    public EqualsIntrinsic getEqualsIntrinsic(@NotNull FunctionDescriptor descriptor) {
        return this.equalsIntrinsics.get(descriptor.getOriginal());
    }

    private final class IntrinsicDeclarationVisitor
    extends DeclarationDescriptorVisitor<Void, Void> {
        private IntrinsicDeclarationVisitor() {
        }

        @Override
        public Void visitClassDescriptor(@NotNull ClassDescriptor descriptor, @Nullable Void nothing) {
            for (DeclarationDescriptor memberDescriptor : descriptor.getDefaultType().getMemberScope().getAllDescriptors()) {
                memberDescriptor.accept(this, null);
            }
            return null;
        }

        @Override
        public Void visitFunctionDescriptor(@NotNull FunctionDescriptor descriptor, @Nullable Void nothing) {
            if (!Intrinsics.this.isIntrinsic(descriptor)) {
                this.declareOperatorIntrinsic(descriptor);
            }
            return null;
        }

        void declareOperatorIntrinsic(@NotNull FunctionDescriptor descriptor) {
            this.tryResolveAsEqualsCompareToOrRangeToIntrinsic(descriptor);
            this.tryResolveAsUnaryIntrinsics(descriptor);
            this.tryResolveAsBinaryIntrinsics(descriptor);
        }

        private void tryResolveAsEqualsCompareToOrRangeToIntrinsic(@NotNull FunctionDescriptor descriptor) {
            Name functionName = descriptor.getName();
            if (functionName.equals(OperatorConventions.COMPARE_TO)) {
                Intrinsics.this.compareToIntrinsics.put(descriptor, PrimitiveCompareToIntrinsic.newInstance());
            }
            if (functionName.equals(OperatorConventions.EQUALS)) {
                Intrinsics.this.equalsIntrinsics.put(descriptor, PrimitiveEqualsIntrinsic.newInstance());
            }
            if (functionName.equals(Name.identifier("rangeTo"))) {
                Intrinsics.this.functionIntrinsics.put(descriptor, PrimitiveRangeToIntrinsic.newInstance());
            }
        }

        private void tryResolveAsUnaryIntrinsics(@NotNull FunctionDescriptor descriptor) {
            Name functionName = descriptor.getName();
            JetToken token = (JetToken)((ImmutableBiMap)OperatorConventions.UNARY_OPERATION_NAMES.inverse()).get(functionName);
            if (token == null) {
                return;
            }
            if (!this.isUnaryOperation(descriptor)) {
                return;
            }
            Intrinsics.this.functionIntrinsics.put(descriptor, PrimitiveUnaryOperationIntrinsic.newInstance(token));
        }

        private void tryResolveAsBinaryIntrinsics(@NotNull FunctionDescriptor descriptor) {
            Name functionName = descriptor.getName();
            if (this.isUnaryOperation(descriptor)) {
                return;
            }
            JetToken token = (JetToken)((ImmutableBiMap)OperatorConventions.BINARY_OPERATION_NAMES.inverse()).get(functionName);
            if (token == null) {
                return;
            }
            if (!OperatorTable.hasCorrespondingBinaryOperator(token)) {
                return;
            }
            Intrinsics.this.functionIntrinsics.put(descriptor, PrimitiveBinaryOperationIntrinsic.newInstance(token));
        }

        private boolean isUnaryOperation(@NotNull FunctionDescriptor descriptor) {
            return !JsDescriptorUtils.hasParameters(descriptor);
        }
    }
}

