/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.Intrinsic;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class CallStandardMethodIntrinsic
implements Intrinsic {
    @NotNull
    private final String methodName;
    private final boolean receiverShouldBeNotNull;
    private final int expectedParamsNumber;

    public CallStandardMethodIntrinsic(@NotNull String methodName, boolean receiverShouldBeNotNull, int expectedParamsNumber) {
        this.methodName = methodName;
        this.receiverShouldBeNotNull = receiverShouldBeNotNull;
        this.expectedParamsNumber = expectedParamsNumber;
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
        assert (receiver != null == this.receiverShouldBeNotNull);
        assert (arguments.size() == this.expectedParamsNumber);
        JsNameRef iteratorFunName = AstUtil.newQualifiedNameRef(this.methodName);
        return JsAstUtils.newInvocation(iteratorFunName, CallStandardMethodIntrinsic.composeArguments(receiver, arguments));
    }

    @NotNull
    private static List<JsExpression> composeArguments(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments) {
        if (receiver != null) {
            ArrayList<JsExpression> args = Lists.newArrayList();
            args.add(receiver);
            args.addAll(arguments);
            return args;
        }
        return arguments;
    }
}

