/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.Intrinsic;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class BuiltInFunctionIntrinsic
implements Intrinsic {
    @NotNull
    private final String functionName;

    public BuiltInFunctionIntrinsic(@NotNull String functionName) {
        this.functionName = functionName;
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
        assert (receiver != null);
        JsNameRef functionReference = AstUtil.newQualifiedNameRef(this.functionName);
        JsAstUtils.setQualifier(functionReference, receiver);
        return JsAstUtils.newInvocation(functionReference, arguments);
    }
}

