/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.initializer;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.initializer.InitializerVisitor;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class NamespaceInitializerTranslator {
    @NotNull
    private final NamespaceDescriptor namespace;
    @NotNull
    private final TranslationContext namespaceContext;

    public NamespaceInitializerTranslator(@NotNull NamespaceDescriptor namespace, @NotNull TranslationContext context) {
        this.namespace = namespace;
        this.namespaceContext = context;
    }

    @NotNull
    public JsFunction generateInitializeMethod() {
        JsFunction result = JsAstUtils.createFunctionWithEmptyBody(this.namespaceContext.jsScope());
        TranslationContext namespaceInitializerContext = this.namespaceContext.innerContextWithGivenScopeAndBlock(result.getScope(), result.getBody());
        List<JsStatement> initializerStatements = new InitializerVisitor().traverseNamespace(this.namespace, namespaceInitializerContext);
        result.getBody().getStatements().addAll(initializerStatements);
        return result;
    }
}

