/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.initializer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.general.TranslatorVisitor;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class InitializerVisitor
extends TranslatorVisitor<List<JsStatement>> {
    @Override
    @NotNull
    public final List<JsStatement> visitProperty(@NotNull JetProperty property, @NotNull TranslationContext context) {
        JetExpression initializer = property.getInitializer();
        if (initializer == null) {
            return Collections.emptyList();
        }
        return InitializerVisitor.generateInitializerForProperty(BindingUtils.getPropertyDescriptor(context.bindingContext(), property), Translation.translateAsExpression(initializer, context), context);
    }

    @NotNull
    private static List<JsStatement> generateInitializerForProperty(@NotNull PropertyDescriptor descriptor, @NotNull JsExpression value, @NotNull TranslationContext context) {
        return Collections.singletonList(InitializerUtils.generateInitializerForProperty(context, descriptor, value));
    }

    @Override
    @NotNull
    public List<JsStatement> visitAnonymousInitializer(@NotNull JetClassInitializer initializer, @NotNull TranslationContext context) {
        return Arrays.asList(Translation.translateAsStatement(initializer.getBody(), context));
    }

    @Override
    @NotNull
    public List<JsStatement> visitDeclaration(@NotNull JetDeclaration expression, @NotNull TranslationContext context) {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public final List<JsStatement> visitObjectDeclarationName(@NotNull JetObjectDeclarationName objectName, @NotNull TranslationContext context) {
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptorForObjectDeclaration(context.bindingContext(), objectName);
        JetObjectDeclaration objectDeclaration = PsiUtils.getObjectDeclarationForName(objectName);
        JsExpression objectValue = ClassTranslator.generateClassCreationExpression(objectDeclaration, context);
        return InitializerVisitor.generateInitializerForProperty(propertyDescriptor, objectValue, context);
    }

    @NotNull
    private List<JsStatement> generateInitializerStatements(@NotNull List<JetDeclaration> declarations, @NotNull TranslationContext context) {
        ArrayList<JsStatement> statements = Lists.newArrayList();
        for (JetDeclaration declaration : declarations) {
            statements.addAll((Collection<JsStatement>)declaration.accept(this, context));
        }
        return statements;
    }

    @NotNull
    public final List<JsStatement> traverseClass(@NotNull JetClassOrObject expression, @NotNull TranslationContext context) {
        return this.generateInitializerStatements(expression.getDeclarations(), context);
    }

    @NotNull
    public final List<JsStatement> traverseNamespace(@NotNull NamespaceDescriptor namespace, @NotNull TranslationContext context) {
        return this.generateInitializerStatements(BindingUtils.getDeclarationsForNamespace(context.bindingContext(), namespace), context);
    }
}

