/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.initializer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class InitializerUtils {
    private InitializerUtils() {
    }

    @NotNull
    public static JsPropertyInitializer generateInitializeMethod(@NotNull JsFunction initializerFunction) {
        JsPropertyInitializer initializer = new JsPropertyInitializer();
        initializer.setLabelExpr(Namer.initializeMethodReference());
        initializer.setValueExpr(initializerFunction);
        return initializer;
    }

    @NotNull
    public static JsStatement generateInitializerForProperty(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor, @NotNull JsExpression value) {
        if (context.isEcma5()) {
            return JsAstUtils.definePropertyDataDescriptor(descriptor, value, context).makeStmt();
        }
        return TranslationUtils.assignmentToBackingField(context, descriptor, value).makeStmt();
    }
}

