/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.general;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsPrettyNamer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.jet.plugin.JetMainDetector;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.facade.MainCallParameters;
import org.jetbrains.k2js.facade.exceptions.MainFunctionNotFoundException;
import org.jetbrains.k2js.facade.exceptions.TranslationException;
import org.jetbrains.k2js.facade.exceptions.TranslationInternalException;
import org.jetbrains.k2js.facade.exceptions.UnsupportedFeatureException;
import org.jetbrains.k2js.translate.context.StaticContext;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.declaration.NamespaceDeclarationTranslator;
import org.jetbrains.k2js.translate.expression.ExpressionVisitor;
import org.jetbrains.k2js.translate.expression.FunctionTranslator;
import org.jetbrains.k2js.translate.expression.PatternTranslator;
import org.jetbrains.k2js.translate.expression.WhenTranslator;
import org.jetbrains.k2js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.k2js.translate.initializer.NamespaceInitializerTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.dangerous.DangerousData;
import org.jetbrains.k2js.translate.utils.dangerous.DangerousTranslator;

public final class Translation {
    private Translation() {
    }

    @NotNull
    public static FunctionTranslator functionTranslator(@NotNull JetDeclarationWithBody function, @NotNull TranslationContext context) {
        return FunctionTranslator.newInstance(function, context);
    }

    @NotNull
    public static List<JsStatement> translateFiles(@NotNull List<JetFile> files, @NotNull TranslationContext context) {
        return NamespaceDeclarationTranslator.translateFiles(files, context);
    }

    @NotNull
    public static JsExpression translateClassDeclaration(@NotNull JetClass classDeclaration, @NotNull Map<JsName, JsName> aliasingMap, @NotNull TranslationContext context) {
        return ClassTranslator.generateClassCreationExpression(classDeclaration, aliasingMap, context);
    }

    @NotNull
    public static PatternTranslator patternTranslator(@NotNull TranslationContext context) {
        return PatternTranslator.newInstance(context);
    }

    @NotNull
    public static JsNode translateExpression(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        JsName aliasForExpression = context.aliasingContext().getAliasForExpression(expression);
        if (aliasForExpression != null) {
            return aliasForExpression.makeRef();
        }
        DangerousData data = DangerousData.collect(expression, context);
        if (data.shouldBeTranslated()) {
            return DangerousTranslator.translate(data, context);
        }
        return Translation.doTranslateExpression(expression, context);
    }

    @NotNull
    public static JsNode doTranslateExpression(JetExpression expression, TranslationContext context) {
        return expression.accept(new ExpressionVisitor(), context);
    }

    @NotNull
    public static JsExpression translateAsExpression(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        return JsAstUtils.convertToExpression(Translation.translateExpression(expression, context));
    }

    @NotNull
    public static JsStatement translateAsStatement(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        return JsAstUtils.convertToStatement(Translation.translateExpression(expression, context));
    }

    @NotNull
    public static JsNode translateWhenExpression(@NotNull JetWhenExpression expression, @NotNull TranslationContext context) {
        return WhenTranslator.translateWhenExpression(expression, context);
    }

    @NotNull
    public static JsFunction generateClassInitializerMethod(@NotNull JetClassOrObject classDeclaration, @NotNull TranslationContext context) {
        ClassInitializerTranslator classInitializerTranslator = new ClassInitializerTranslator(classDeclaration, context);
        return classInitializerTranslator.generateInitializeMethod();
    }

    @NotNull
    public static JsFunction generateNamespaceInitializerMethod(@NotNull NamespaceDescriptor namespace, @NotNull TranslationContext context) {
        NamespaceInitializerTranslator namespaceInitializerTranslator = new NamespaceInitializerTranslator(namespace, context);
        return namespaceInitializerTranslator.generateInitializeMethod();
    }

    @NotNull
    public static JsProgram generateAst(@NotNull BindingContext bindingContext, @NotNull List<JetFile> files, @NotNull MainCallParameters mainCallParameters, @NotNull EcmaVersion ecmaVersion) throws TranslationException {
        try {
            return Translation.doGenerateAst(bindingContext, files, mainCallParameters, ecmaVersion);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedFeatureException("Unsupported feature used.", e);
        }
        catch (Throwable e) {
            throw new TranslationInternalException(e);
        }
    }

    @NotNull
    private static JsProgram doGenerateAst(@NotNull BindingContext bindingContext, @NotNull List<JetFile> files, @NotNull MainCallParameters mainCallParameters, @NotNull EcmaVersion ecmaVersion) throws MainFunctionNotFoundException {
        JetStandardLibrary standardLibrary = JetStandardLibrary.getInstance();
        StaticContext staticContext = StaticContext.generateStaticContext(standardLibrary, bindingContext, ecmaVersion);
        JsProgram program = staticContext.getProgram();
        JsBlock block = program.getGlobalBlock();
        JsFunction rootFunction = JsAstUtils.createPackage(block.getStatements(), program.getScope());
        List<JsStatement> statements = rootFunction.getBody().getStatements();
        statements.add(program.getStringLiteral("use strict").makeStmt());
        TranslationContext context = TranslationContext.rootContext(staticContext);
        statements.addAll(Translation.translateFiles(files, context));
        if (mainCallParameters.shouldBeGenerated()) {
            statements.add(Translation.generateCallToMain(context, files, mainCallParameters.arguments()));
        }
        JsPrettyNamer namer = new JsPrettyNamer();
        namer.exec(context.program());
        return context.program();
    }

    @NotNull
    private static JsStatement generateCallToMain(@NotNull TranslationContext context, @NotNull List<JetFile> files, @NotNull List<String> arguments) throws MainFunctionNotFoundException {
        JetNamedFunction mainFunction = JetMainDetector.getMainFunction(files);
        if (mainFunction == null) {
            throw new MainFunctionNotFoundException("Main function was not found. Please check compiler arguments");
        }
        JsInvocation translatedCall = Translation.generateInvocation(context, mainFunction);
        Translation.setArguments(context, arguments, translatedCall);
        return translatedCall.makeStmt();
    }

    @NotNull
    private static JsInvocation generateInvocation(@NotNull TranslationContext context, @NotNull JetNamedFunction mainFunction) {
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor(context.bindingContext(), mainFunction);
        JsExpression translatedCall = CallBuilder.build(context).descriptor(functionDescriptor).translate();
        assert (translatedCall instanceof JsInvocation);
        return (JsInvocation)translatedCall;
    }

    private static void setArguments(@NotNull TranslationContext context, @NotNull List<String> arguments, @NotNull JsInvocation translatedCall) {
        JsArrayLiteral arrayLiteral = new JsArrayLiteral();
        arrayLiteral.getExpressions().addAll(JsAstUtils.toStringLiteralList(arguments, context.program()));
        JsAstUtils.setArguments(translatedCall, Collections.singletonList(arrayLiteral));
    }
}

