/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression.foreach;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.foreach.ForTranslator;
import org.jetbrains.k2js.translate.expression.foreach.RangeForTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TemporariesUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class RangeLiteralForTranslator
extends ForTranslator {
    @NotNull
    private final JsExpression rangeStart;
    @NotNull
    private final TemporaryVariable rangeEnd;

    @NotNull
    public static JsStatement doTranslate(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        return new RangeLiteralForTranslator(expression, context).translate();
    }

    public static boolean isApplicable(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        JetExpression loopRange = PsiUtils.getLoopRange(expression);
        if (!(loopRange instanceof JetBinaryExpression)) {
            return false;
        }
        boolean isRangeToOperation = ((JetBinaryExpression)loopRange).getOperationToken() == JetTokens.RANGE;
        return isRangeToOperation && RangeForTranslator.isApplicable(expression, context);
    }

    private RangeLiteralForTranslator(@NotNull JetForExpression forExpression, @NotNull TranslationContext context) {
        super(forExpression, context);
        JetExpression loopRange = PsiUtils.getLoopRange(this.expression);
        assert (loopRange instanceof JetBinaryExpression);
        JetBinaryExpression loopRangeAsBinary = (JetBinaryExpression)loopRange;
        this.rangeStart = TranslationUtils.translateLeftExpression(context, loopRangeAsBinary);
        this.rangeEnd = context.declareTemporary(this.getRangeEnd(loopRangeAsBinary));
    }

    @NotNull
    private JsExpression getRangeEnd(@NotNull JetBinaryExpression loopRangeAsBinary) {
        JsExpression rightExpression = TranslationUtils.translateRightExpression(this.context(), loopRangeAsBinary);
        return new JsBinaryOperation(JsBinaryOperator.ADD, rightExpression, this.program().getNumberLiteral(1.0));
    }

    @NotNull
    private JsBlock translate() {
        ArrayList<JsStatement> blockStatements = Lists.newArrayList();
        blockStatements.add(TemporariesUtils.temporariesInitialization(this.rangeEnd).makeStmt());
        blockStatements.add(JsAstUtils.generateForExpression(this.initExpression(), this.getCondition(), this.getIncrExpression(), this.translateOriginalBodyExpression()));
        return JsAstUtils.newBlock(blockStatements);
    }

    @NotNull
    private JsVars initExpression() {
        return JsAstUtils.newVar(this.parameterName, this.rangeStart);
    }

    @NotNull
    private JsExpression getCondition() {
        return JsAstUtils.inequality(this.parameterName.makeRef(), this.rangeEnd.reference());
    }

    @NotNull
    private JsExpression getIncrExpression() {
        return new JsPrefixOperation(JsUnaryOperator.INC, this.parameterName.makeRef());
    }
}

