/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression.foreach;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsConditional;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.foreach.ForTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TemporariesUtils;

public final class RangeForTranslator
extends ForTranslator {
    @NotNull
    private final TemporaryVariable rangeExpression;
    @NotNull
    private final TemporaryVariable incrVar;
    @NotNull
    private final TemporaryVariable start;
    @NotNull
    private final TemporaryVariable end;

    @NotNull
    public static JsStatement doTranslate(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        return new RangeForTranslator(expression, context).translate();
    }

    public static boolean isApplicable(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        JetExpression loopRange = PsiUtils.getLoopRange(expression);
        JetType rangeType = BindingUtils.getTypeForExpression(context.bindingContext(), loopRange);
        return JsDescriptorUtils.getClassDescriptorForType(rangeType).getName().getName().equals("IntRange");
    }

    private RangeForTranslator(@NotNull JetForExpression forExpression, @NotNull TranslationContext context) {
        super(forExpression, context);
        this.rangeExpression = context.declareTemporary(Translation.translateAsExpression(PsiUtils.getLoopRange(this.expression), context));
        JsExpression isReversed = this.callFunction("get_reversed");
        JsConditional incrVarValue = new JsConditional(isReversed, this.program().getNumberLiteral(-1.0), this.program().getNumberLiteral(1.0));
        this.incrVar = this.context().declareTemporary(incrVarValue);
        this.start = this.context().declareTemporary(this.callFunction("get_start"));
        this.end = this.context().declareTemporary(JsAstUtils.sum(this.callFunction("get_end"), this.incrVar.reference()));
    }

    @NotNull
    private JsBlock translate() {
        ArrayList<JsStatement> blockStatements = Lists.newArrayList();
        blockStatements.add(TemporariesUtils.temporariesInitialization(this.rangeExpression, this.incrVar, this.start, this.end).makeStmt());
        blockStatements.add(this.generateForExpression());
        return JsAstUtils.newBlock(blockStatements);
    }

    @NotNull
    private JsFor generateForExpression() {
        JsFor result = new JsFor();
        result.setInitVars(this.initExpression());
        result.setCondition(this.getCondition());
        result.setIncrExpr(this.getIncrExpression());
        result.setBody(this.translateOriginalBodyExpression());
        return result;
    }

    @NotNull
    private JsVars initExpression() {
        return JsAstUtils.newVar(this.parameterName, this.start.reference());
    }

    @NotNull
    private JsExpression getCondition() {
        return JsAstUtils.inequality(this.parameterName.makeRef(), this.end.reference());
    }

    @NotNull
    private JsExpression getIncrExpression() {
        return JsAstUtils.addAssign(this.parameterName.makeRef(), this.incrVar.reference());
    }

    @NotNull
    private JsExpression getField(@NotNull String fieldName) {
        JsNameRef nameRef = AstUtil.newQualifiedNameRef(fieldName);
        JsAstUtils.setQualifier(nameRef, this.rangeExpression.reference());
        return nameRef;
    }

    @NotNull
    private JsExpression callFunction(@NotNull String funName) {
        return AstUtil.newInvocation(this.getField(funName), new JsExpression[0]);
    }
}

