/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression.foreach;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsWhile;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.foreach.ForTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class IteratorForTranslator
extends ForTranslator {
    @NotNull
    private final TemporaryVariable iterator = this.context().declareTemporary(this.iteratorMethodInvocation());

    @NotNull
    public static JsStatement doTranslate(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        return new IteratorForTranslator(expression, context).translate();
    }

    private IteratorForTranslator(@NotNull JetForExpression forExpression, @NotNull TranslationContext context) {
        super(forExpression, context);
    }

    @NotNull
    private JsBlock translate() {
        JsBlock bodyBlock = this.generateCycleBody();
        JsWhile cycle = new JsWhile(this.hasNextMethodInvocation(), bodyBlock);
        return AstUtil.newBlock(this.iterator.assignmentExpression().makeStmt(), cycle);
    }

    @NotNull
    private JsBlock generateCycleBody() {
        JsBlock cycleBody = new JsBlock();
        JsVars parameterAssignment = JsAstUtils.newVar(this.parameterName, this.nextMethodInvocation());
        JsNode originalBody = Translation.translateExpression(PsiUtils.getLoopBody(this.expression), this.context().innerBlock(cycleBody));
        cycleBody.getStatements().add(parameterAssignment);
        cycleBody.getStatements().add(JsAstUtils.convertToBlock(originalBody));
        return cycleBody;
    }

    @NotNull
    private JsExpression nextMethodInvocation() {
        FunctionDescriptor nextFunction = BindingUtils.getNextFunction(this.bindingContext(), PsiUtils.getLoopRange(this.expression));
        return this.translateMethodInvocation(this.iterator.reference(), nextFunction);
    }

    @NotNull
    private JsExpression hasNextMethodInvocation() {
        CallableDescriptor hasNextFunction = BindingUtils.getHasNextCallable(this.bindingContext(), PsiUtils.getLoopRange(this.expression));
        if (hasNextFunction instanceof FunctionDescriptor && !IteratorForTranslator.isJavaUtilIterator(hasNextFunction)) {
            return this.translateMethodInvocation(this.iterator.reference(), hasNextFunction);
        }
        JsNameRef hasNext = new JsNameRef(Namer.getNameForAccessor("hasNext", true, this.context().isEcma5()));
        hasNext.setQualifier(this.iterator.reference());
        if (this.context().isEcma5()) {
            return hasNext;
        }
        JsInvocation invocation = new JsInvocation();
        invocation.setQualifier(hasNext);
        return invocation;
    }

    private static boolean isJavaUtilIterator(CallableDescriptor descriptor) {
        DeclarationDescriptor declaration = descriptor.getContainingDeclaration();
        return declaration != null && declaration.getName().getName().equals("Iterator");
    }

    @NotNull
    private JsExpression iteratorMethodInvocation() {
        JetExpression rangeExpression = PsiUtils.getLoopRange(this.expression);
        JsExpression range = Translation.translateAsExpression(rangeExpression, this.context());
        FunctionDescriptor iteratorFunction = BindingUtils.getIteratorFunction(this.bindingContext(), rangeExpression);
        return this.translateMethodInvocation(range, iteratorFunction);
    }

    @NotNull
    private JsExpression translateMethodInvocation(@Nullable JsExpression receiver, @NotNull CallableDescriptor descriptor) {
        return CallBuilder.build(this.context()).receiver(receiver).descriptor(descriptor).translate();
    }
}

