/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression.foreach;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.foreach.ArrayForTranslator;
import org.jetbrains.k2js.translate.expression.foreach.IteratorForTranslator;
import org.jetbrains.k2js.translate.expression.foreach.RangeForTranslator;
import org.jetbrains.k2js.translate.expression.foreach.RangeLiteralForTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public abstract class ForTranslator
extends AbstractTranslator {
    @NotNull
    protected final JetForExpression expression;
    @NotNull
    protected final JsName parameterName;

    @NotNull
    public static JsStatement translate(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        if (RangeLiteralForTranslator.isApplicable(expression, context)) {
            return RangeLiteralForTranslator.doTranslate(expression, context);
        }
        if (RangeForTranslator.isApplicable(expression, context)) {
            return RangeForTranslator.doTranslate(expression, context);
        }
        if (ArrayForTranslator.isApplicable(expression, context)) {
            return ArrayForTranslator.doTranslate(expression, context);
        }
        return IteratorForTranslator.doTranslate(expression, context);
    }

    protected ForTranslator(@NotNull JetForExpression forExpression, @NotNull TranslationContext context) {
        super(context);
        this.expression = forExpression;
        this.parameterName = this.declareParameter();
    }

    @NotNull
    private JsName declareParameter() {
        JetParameter loopParameter = PsiUtils.getLoopParameter(this.expression);
        return this.context().getNameForElement(loopParameter);
    }

    @NotNull
    protected JsStatement translateOriginalBodyExpression() {
        return Translation.translateAsStatement(PsiUtils.getLoopBody(this.expression), this.context());
    }
}

