/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression.foreach;

import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.foreach.ForTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.intrinsic.Intrinsic;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TemporariesUtils;

public final class ArrayForTranslator
extends ForTranslator {
    @NotNull
    private final TemporaryVariable loopRange;
    @NotNull
    private final TemporaryVariable end;
    @NotNull
    private final TemporaryVariable index;

    @NotNull
    public static JsStatement doTranslate(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        return new ArrayForTranslator(expression, context).translate();
    }

    public static boolean isApplicable(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        JetExpression loopRange = PsiUtils.getLoopRange(expression);
        JetType rangeType = BindingUtils.getTypeForExpression(context.bindingContext(), loopRange);
        return JsDescriptorUtils.getClassDescriptorForType(rangeType).getName().getName().equals("Array") || JsDescriptorUtils.getClassDescriptorForType(rangeType).getName().getName().equals("IntArray");
    }

    private ArrayForTranslator(@NotNull JetForExpression forExpression, @NotNull TranslationContext context) {
        super(forExpression, context);
        this.loopRange = context.declareTemporary(Translation.translateAsExpression(PsiUtils.getLoopRange(this.expression), context));
        Intrinsic lengthPropertyIntrinsic = this.context().intrinsics().getLengthPropertyIntrinsic();
        JsExpression length = lengthPropertyIntrinsic.apply(this.loopRange.reference(), Collections.<JsExpression>emptyList(), this.context());
        this.end = this.context().declareTemporary(length);
        this.index = this.context().declareTemporary(this.program().getNumberLiteral(0.0));
    }

    @NotNull
    private JsBlock translate() {
        ArrayList<JsStatement> blockStatements = Lists.newArrayList();
        blockStatements.add(TemporariesUtils.temporariesInitialization(this.loopRange, this.end).makeStmt());
        blockStatements.add(JsAstUtils.generateForExpression(this.getInitExpression(), this.getCondition(), this.getIncrementExpression(), this.getBody()));
        return JsAstUtils.newBlock(blockStatements);
    }

    @NotNull
    private JsStatement getBody() {
        JsArrayAccess arrayAccess = new JsArrayAccess(this.loopRange.reference(), this.index.reference());
        JsVars currentVar = JsAstUtils.newVar(this.parameterName, arrayAccess);
        JsStatement realBody = this.translateOriginalBodyExpression();
        return AstUtil.newBlock(currentVar, realBody);
    }

    @NotNull
    private JsVars getInitExpression() {
        return JsAstUtils.newVar(this.index.name(), this.program().getNumberLiteral(0.0));
    }

    @NotNull
    private JsExpression getCondition() {
        return JsAstUtils.inequality(this.index.reference(), this.end.reference());
    }

    @NotNull
    private JsExpression getIncrementExpression() {
        return new JsPrefixOperation(JsUnaryOperator.INC, this.index.reference());
    }
}

