/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBreak;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPattern;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.mutator.AssignToExpressionMutator;
import org.jetbrains.k2js.translate.utils.mutator.LastExpressionMutator;

public final class WhenTranslator
extends AbstractTranslator {
    @NotNull
    private final JetWhenExpression whenExpression;
    @Nullable
    private final JsExpression expressionToMatch;
    @NotNull
    private final TemporaryVariable dummyCounter;
    @NotNull
    private final TemporaryVariable result;
    private int currentEntryNumber = 0;

    @NotNull
    public static JsNode translateWhenExpression(@NotNull JetWhenExpression expression, @NotNull TranslationContext context) {
        WhenTranslator translator = new WhenTranslator(expression, context);
        return translator.translate();
    }

    private WhenTranslator(@NotNull JetWhenExpression expression, @NotNull TranslationContext context) {
        super(context);
        this.whenExpression = expression;
        this.expressionToMatch = this.translateExpressionToMatch(this.whenExpression);
        this.dummyCounter = context.declareTemporary(this.program().getNumberLiteral(0.0));
        this.result = context.declareTemporary(this.program().getNullLiteral());
    }

    @NotNull
    JsNode translate() {
        JsFor resultingFor = this.generateDummyFor();
        List<JsStatement> entries = this.translateEntries();
        resultingFor.setBody(JsAstUtils.newBlock(entries));
        this.context().addStatementToCurrentBlock(resultingFor);
        return this.result.reference();
    }

    @NotNull
    private List<JsStatement> translateEntries() {
        ArrayList<JsStatement> entries = new ArrayList<JsStatement>();
        for (JetWhenEntry entry : this.whenExpression.getEntries()) {
            entries.add(this.surroundWithDummyIf(this.translateEntry(entry)));
        }
        return entries;
    }

    @NotNull
    private JsStatement surroundWithDummyIf(@NotNull JsStatement entryStatement) {
        JsNumberLiteral jsEntryNumber = this.program().getNumberLiteral(this.currentEntryNumber);
        JsBinaryOperation stepNumberEqualsCurrentEntryNumber = JsAstUtils.equality(this.dummyCounter.reference(), jsEntryNumber);
        ++this.currentEntryNumber;
        return new JsIf(stepNumberEqualsCurrentEntryNumber, entryStatement, null);
    }

    @NotNull
    private JsFor generateDummyFor() {
        JsFor result = new JsFor();
        result.setInitExpr(this.dummyCounter.assignmentExpression());
        result.setIncrExpr(this.generateIncrementStatement());
        result.setCondition(this.generateConditionStatement());
        return result;
    }

    @NotNull
    private JsBinaryOperation generateConditionStatement() {
        JsNumberLiteral entriesNumber = this.program().getNumberLiteral(this.whenExpression.getEntries().size());
        return new JsBinaryOperation(JsBinaryOperator.LT, this.dummyCounter.reference(), entriesNumber);
    }

    @NotNull
    private JsPrefixOperation generateIncrementStatement() {
        return new JsPrefixOperation(JsUnaryOperator.INC, this.dummyCounter.reference());
    }

    @NotNull
    private JsStatement translateEntry(@NotNull JetWhenEntry entry) {
        JsStatement statementToExecute = this.withReturnValueCaptured(this.translateEntryExpression(entry));
        if (entry.isElse()) {
            return statementToExecute;
        }
        JsExpression condition = this.translateConditions(entry);
        return new JsIf(condition, WhenTranslator.addDummyBreak(statementToExecute), null);
    }

    @NotNull
    JsStatement withReturnValueCaptured(@NotNull JsNode node) {
        return JsAstUtils.convertToStatement(LastExpressionMutator.mutateLastExpression(node, new AssignToExpressionMutator(this.result.reference())));
    }

    @NotNull
    private JsNode translateEntryExpression(@NotNull JetWhenEntry entry) {
        JetExpression expressionToExecute = entry.getExpression();
        assert (expressionToExecute != null) : "WhenEntry should have whenExpression to execute.";
        return Translation.translateExpression(expressionToExecute, this.context());
    }

    @NotNull
    private JsExpression translateConditions(@NotNull JetWhenEntry entry) {
        ArrayList<JsExpression> conditions = new ArrayList<JsExpression>();
        for (JetWhenCondition condition : entry.getConditions()) {
            conditions.add(this.translateCondition(condition));
        }
        return WhenTranslator.anyOfThemIsTrue(conditions);
    }

    @NotNull
    private static JsExpression anyOfThemIsTrue(List<JsExpression> conditions) {
        assert (!conditions.isEmpty()) : "When entry (not else) should have at least one condition";
        JsExpression current = null;
        for (JsExpression condition : conditions) {
            current = WhenTranslator.addCaseCondition(current, condition);
        }
        assert (current != null);
        return current;
    }

    @NotNull
    private static JsExpression addCaseCondition(@Nullable JsExpression current, @NotNull JsExpression condition) {
        if (current == null) {
            return condition;
        }
        return JsAstUtils.or(current, condition);
    }

    @NotNull
    private JsExpression translateCondition(@NotNull JetWhenCondition condition) {
        if (condition instanceof JetWhenConditionIsPattern || condition instanceof JetWhenConditionWithExpression) {
            return this.translatePatternCondition(condition);
        }
        throw new AssertionError((Object)("Unsupported when condition " + condition.getClass()));
    }

    @NotNull
    private static JsBlock addDummyBreak(@NotNull JsStatement statement) {
        return AstUtil.newBlock(statement, new JsBreak());
    }

    @NotNull
    private JsExpression translatePatternCondition(@NotNull JetWhenCondition condition) {
        JsExpression patternMatchExpression = Translation.patternTranslator(this.context()).translatePattern(WhenTranslator.getPattern(condition), this.expressionToMatch);
        if (WhenTranslator.isNegated(condition)) {
            return JsAstUtils.negated(patternMatchExpression);
        }
        return patternMatchExpression;
    }

    private static boolean isNegated(@NotNull JetWhenCondition condition) {
        if (condition instanceof JetWhenConditionIsPattern) {
            return ((JetWhenConditionIsPattern)condition).isNegated();
        }
        return false;
    }

    @NotNull
    private static JetPattern getPattern(@NotNull JetWhenCondition condition) {
        JetPattern pattern;
        if (condition instanceof JetWhenConditionIsPattern) {
            pattern = ((JetWhenConditionIsPattern)condition).getPattern();
        } else if (condition instanceof JetWhenConditionWithExpression) {
            pattern = ((JetWhenConditionWithExpression)condition).getPattern();
        } else {
            throw new AssertionError((Object)"Wrong type of JetWhenCondition");
        }
        assert (pattern != null) : "Condition should have a non null pattern.";
        return pattern;
    }

    @Nullable
    private JsExpression translateExpressionToMatch(@NotNull JetWhenExpression expression) {
        JetExpression subject = expression.getSubjectExpression();
        if (subject == null) {
            return null;
        }
        return Translation.translateAsExpression(subject, this.context());
    }
}

