/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class StringTemplateTranslator
extends AbstractTranslator {
    @NotNull
    private final JetStringTemplateExpression expression;

    @NotNull
    public static JsExpression translate(@NotNull JetStringTemplateExpression expression, @NotNull TranslationContext context) {
        return new StringTemplateTranslator(expression, context).translate();
    }

    private StringTemplateTranslator(@NotNull JetStringTemplateExpression expression, @NotNull TranslationContext context) {
        super(context);
        this.expression = expression;
    }

    @NotNull
    private JsExpression translate() {
        assert (this.expression.getEntries().length != 0) : "String template must have one or more entries.";
        EntryVisitor entryVisitor = new EntryVisitor();
        for (JetStringTemplateEntry entry : this.expression.getEntries()) {
            entry.accept(entryVisitor);
        }
        return entryVisitor.getResultingExpression();
    }

    private final class EntryVisitor
    extends JetVisitorVoid {
        @Nullable
        private JsExpression resultingExpression = null;

        private EntryVisitor() {
        }

        void append(@NotNull JsExpression expression) {
            this.resultingExpression = this.resultingExpression == null ? expression : JsAstUtils.sum(this.resultingExpression, expression);
        }

        @Override
        public void visitStringTemplateEntryWithExpression(@NotNull JetStringTemplateEntryWithExpression entry) {
            JetExpression entryExpression = entry.getExpression();
            assert (entryExpression != null) : "JetStringTemplateEntryWithExpression must have not null entry expression.";
            this.append(Translation.translateAsExpression(entryExpression, StringTemplateTranslator.this.context()));
        }

        @Override
        public void visitLiteralStringTemplateEntry(@NotNull JetLiteralStringTemplateEntry entry) {
            this.appendText(entry.getText());
        }

        @Override
        public void visitEscapeStringTemplateEntry(@NotNull JetEscapeStringTemplateEntry entry) {
            this.appendText(entry.getUnescapedValue());
        }

        private void appendText(@NotNull String text) {
            this.append(StringTemplateTranslator.this.program().getStringLiteral(text));
        }

        @NotNull
        public JsExpression getResultingExpression() {
            assert (this.resultingExpression != null);
            return this.resultingExpression;
        }
    }
}

