/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBooleanLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionPattern;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetPattern;
import org.jetbrains.jet.lang.psi.JetTypePattern;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class PatternTranslator
extends AbstractTranslator {
    @NotNull
    public static PatternTranslator newInstance(@NotNull TranslationContext context) {
        return new PatternTranslator(context);
    }

    private PatternTranslator(@NotNull TranslationContext context) {
        super(context);
    }

    @NotNull
    public JsExpression translateIsExpression(@NotNull JetIsExpression expression) {
        JsExpression left = Translation.translateAsExpression(expression.getLeftHandSide(), this.context());
        JetPattern pattern = PsiUtils.getPattern(expression);
        JsExpression resultingExpression = this.translatePattern(pattern, left);
        if (expression.isNegated()) {
            return JsAstUtils.negated(resultingExpression);
        }
        return resultingExpression;
    }

    @NotNull
    public JsExpression translatePattern(@NotNull JetPattern pattern, @Nullable JsExpression expressionToMatch) {
        if (expressionToMatch == null) {
            assert (pattern instanceof JetExpressionPattern) : "When using when without parameters we can have only expression patterns";
            return this.translateExpressionForExpressionPattern((JetExpressionPattern)pattern);
        }
        if (pattern instanceof JetTypePattern) {
            return this.translateTypePattern(expressionToMatch, (JetTypePattern)pattern);
        }
        if (pattern instanceof JetExpressionPattern) {
            return this.translateExpressionPattern(expressionToMatch, (JetExpressionPattern)pattern);
        }
        throw new AssertionError((Object)("Unsupported pattern type " + pattern.getClass()));
    }

    @NotNull
    private JsExpression translateTypePattern(@NotNull JsExpression expressionToMatch, @NotNull JetTypePattern pattern) {
        JsExpression result = this.translateAsIntrinsicTypeCheck(expressionToMatch, pattern);
        if (result != null) {
            return result;
        }
        return this.translateAsIsCheck(expressionToMatch, pattern);
    }

    @NotNull
    private JsExpression translateAsIsCheck(@NotNull JsExpression expressionToMatch, @NotNull JetTypePattern pattern) {
        JsInvocation isCheck = AstUtil.newInvocation(this.context().namer().isOperationReference(), expressionToMatch, this.getClassReference(pattern));
        if (this.isNullable(pattern)) {
            return this.addNullCheck(expressionToMatch, isCheck);
        }
        return isCheck;
    }

    @Nullable
    private JsExpression translateAsIntrinsicTypeCheck(@NotNull JsExpression expressionToMatch, @NotNull JetTypePattern pattern) {
        JsBinaryOperation result = null;
        JsName className = this.getClassReference(pattern).getName();
        if (className.getIdent().equals("String")) {
            result = JsAstUtils.typeof(expressionToMatch, this.program().getStringLiteral("string"));
        }
        if (className.getIdent().equals("Int")) {
            result = JsAstUtils.typeof(expressionToMatch, this.program().getStringLiteral("number"));
        }
        return result;
    }

    @NotNull
    private JsExpression addNullCheck(@NotNull JsExpression expressionToMatch, @NotNull JsInvocation isCheck) {
        return JsAstUtils.or(TranslationUtils.isNullCheck(this.context(), expressionToMatch), isCheck);
    }

    private boolean isNullable(JetTypePattern pattern) {
        return BindingUtils.getTypeByReference(this.bindingContext(), PsiUtils.getTypeReference(pattern)).isNullable();
    }

    @NotNull
    private JsNameRef getClassReference(@NotNull JetTypePattern pattern) {
        JetTypeReference typeReference = PsiUtils.getTypeReference(pattern);
        return this.getClassNameReferenceForTypeReference(typeReference);
    }

    @NotNull
    private JsNameRef getClassNameReferenceForTypeReference(@NotNull JetTypeReference typeReference) {
        ClassDescriptor referencedClass = BindingUtils.getClassDescriptorForTypeReference(this.bindingContext(), typeReference);
        return TranslationUtils.getQualifiedReference(this.context(), referencedClass);
    }

    @NotNull
    private JsExpression translateExpressionPattern(@NotNull JsExpression expressionToMatch, JetExpressionPattern pattern) {
        JsExpression expressionToMatchAgainst = this.translateExpressionForExpressionPattern(pattern);
        JsBinaryOperation eq = JsAstUtils.equality(expressionToMatch, expressionToMatchAgainst);
        if (this.context().isEcma5() && (expressionToMatchAgainst instanceof JsNumberLiteral || expressionToMatchAgainst instanceof JsStringLiteral || expressionToMatchAgainst instanceof JsBooleanLiteral)) {
            JsNameRef valueOf = new JsNameRef("valueOf");
            valueOf.setQualifier(expressionToMatch);
            return JsAstUtils.and(valueOf, eq);
        }
        return eq;
    }

    @NotNull
    private JsExpression translateExpressionForExpressionPattern(@NotNull JetExpressionPattern pattern) {
        JetExpression patternExpression = pattern.getExpression();
        assert (patternExpression != null) : "Expression patter should have an expression.";
        return Translation.translateAsExpression(patternExpression, this.context());
    }
}

