/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;
import org.jetbrains.k2js.translate.utils.closure.ClosureContext;
import org.jetbrains.k2js.translate.utils.closure.ClosureUtils;

public final class FunctionTranslator
extends AbstractTranslator {
    @NotNull
    private final TranslationContext functionBodyContext;
    @Nullable
    private TemporaryVariable aliasForContainingClassThis = null;
    @NotNull
    private final JetDeclarationWithBody functionDeclaration;
    @Nullable
    private JsName extensionFunctionReceiverName = null;
    @NotNull
    private final JsFunction functionObject;
    @NotNull
    private final FunctionDescriptor descriptor;
    @NotNull
    private final JsBlock functionBody;

    @NotNull
    public static FunctionTranslator newInstance(@NotNull JetDeclarationWithBody function, @NotNull TranslationContext context) {
        return new FunctionTranslator(function, context);
    }

    private FunctionTranslator(@NotNull JetDeclarationWithBody functionDeclaration, @NotNull TranslationContext context) {
        super(context);
        this.descriptor = BindingUtils.getFunctionDescriptor(context.bindingContext(), functionDeclaration);
        this.functionDeclaration = functionDeclaration;
        this.functionObject = this.context().getFunctionObject(this.descriptor);
        assert (this.functionObject.getParameters().isEmpty());
        this.functionBody = this.functionObject.getBody();
        this.functionBodyContext = this.getFunctionBodyContext();
    }

    @NotNull
    private TranslationContext getFunctionBodyContext() {
        if (this.isLiteral()) {
            return this.getFunctionBodyContextForLiteral();
        }
        if (this.isExtensionFunction()) {
            return this.getFunctionBodyContextForExtensionFunction();
        }
        return this.getContextWithFunctionBodyBlock();
    }

    @NotNull
    private TranslationContext getFunctionBodyContextForLiteral() {
        ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(this.descriptor);
        if (containingClass == null) {
            return this.getContextWithFunctionBodyBlock();
        }
        JsExpression thisQualifier = TranslationUtils.getThisObject(this.context(), containingClass);
        this.aliasForContainingClassThis = this.context().declareTemporary(thisQualifier);
        return this.getContextWithFunctionBodyBlock().innerContextWithThisAliased(containingClass, this.aliasForContainingClassThis.name());
    }

    @NotNull
    private TranslationContext getFunctionBodyContextForExtensionFunction() {
        TranslationContext contextWithFunctionBodyBlock = this.getContextWithFunctionBodyBlock();
        this.extensionFunctionReceiverName = contextWithFunctionBodyBlock.jsScope().declareName(Namer.getReceiverParameterName());
        DeclarationDescriptor expectedReceiverDescriptor = JsDescriptorUtils.getExpectedReceiverDescriptor(this.descriptor);
        assert (expectedReceiverDescriptor != null);
        return contextWithFunctionBodyBlock.innerContextWithThisAliased(expectedReceiverDescriptor, this.extensionFunctionReceiverName);
    }

    @NotNull
    private TranslationContext getContextWithFunctionBodyBlock() {
        return this.context().newDeclaration(this.functionDeclaration).innerBlock(this.functionBody);
    }

    @NotNull
    public JsFunction translateAsLocalFunction() {
        JsName functionName = this.context().getNameForElement(this.functionDeclaration);
        this.generateFunctionObject();
        this.functionObject.setName(functionName);
        return this.functionObject;
    }

    @NotNull
    public JsPropertyInitializer translateAsEcma5PropertyDescriptor() {
        this.generateFunctionObject();
        return TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(this.functionObject, this.descriptor, this.context());
    }

    @NotNull
    public JsPropertyInitializer translateAsMethod() {
        JsName functionName = this.context().getNameForElement(this.functionDeclaration);
        this.generateFunctionObject();
        return new JsPropertyInitializer(functionName.makeRef(), this.functionObject);
    }

    @NotNull
    public JsExpression translateAsLiteral() {
        assert (JsDescriptorUtils.getExpectedThisDescriptor(this.descriptor) == null);
        this.generateFunctionObject();
        ClosureContext closureContext = ClosureUtils.captureClosure(this.context(), (JetElement)((Object)this.functionDeclaration));
        if (closureContext.getDescriptors().isEmpty()) {
            return this.mayBeWrapWithThisAlias();
        }
        return this.wrapInClosureCaptureExpression(this.functionObject, closureContext);
    }

    @NotNull
    private JsExpression mayBeWrapWithThisAlias() {
        if (!this.shouldAliasThisObject()) {
            return this.functionObject;
        }
        assert (this.aliasForContainingClassThis != null);
        return AstUtil.newSequence(this.aliasForContainingClassThis.assignmentExpression(), this.functionObject);
    }

    private boolean shouldAliasThisObject() {
        if (!this.isLiteral()) {
            return false;
        }
        ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(this.descriptor);
        return containingClass != null;
    }

    @NotNull
    private JsExpression wrapInClosureCaptureExpression(@NotNull JsExpression wrappedExpression, @NotNull ClosureContext closureContext) {
        JsFunction dummyFunction = new JsFunction(this.context().jsScope());
        JsInvocation dummyFunctionInvocation = AstUtil.newInvocation(dummyFunction, new JsExpression[0]);
        for (VariableDescriptor variableDescriptor : closureContext.getDescriptors()) {
            dummyFunction.getParameters().add(new JsParameter(this.context().getNameForDescriptor(variableDescriptor)));
            dummyFunctionInvocation.getArguments().add(ReferenceTranslator.translateAsLocalNameReference(variableDescriptor, this.context()));
            if (this.aliasForContainingClassThis == null) continue;
            dummyFunction.getParameters().add(new JsParameter(this.aliasForContainingClassThis.name()));
            dummyFunctionInvocation.getArguments().add(this.aliasForContainingClassThis.initExpression());
        }
        dummyFunction.setBody(AstUtil.newBlock(new JsReturn(wrappedExpression)));
        return dummyFunctionInvocation;
    }

    private void generateFunctionObject() {
        JsAstUtils.setParameters(this.functionObject, this.translateParameters());
        this.translateBody();
    }

    private void translateBody() {
        JetExpression jetBodyExpression = this.functionDeclaration.getBodyExpression();
        if (jetBodyExpression == null) {
            assert (this.descriptor.getModality().equals((Object)Modality.ABSTRACT));
            return;
        }
        this.functionBody.getStatements().add(FunctionBodyTranslator.translateFunctionBody(this.descriptor, this.functionDeclaration, this.functionBodyContext));
    }

    @NotNull
    private List<JsParameter> translateParameters() {
        ArrayList<JsParameter> jsParameters = new ArrayList<JsParameter>();
        this.mayBeAddThisParameterForExtensionFunction(jsParameters);
        for (ValueParameterDescriptor valueParameter : this.descriptor.getValueParameters()) {
            JsName parameterName = this.declareParameter(valueParameter);
            jsParameters.add(new JsParameter(parameterName));
        }
        return jsParameters;
    }

    @NotNull
    private JsName declareParameter(@NotNull ValueParameterDescriptor valueParameter) {
        return this.context().getNameForDescriptor(valueParameter);
    }

    private void mayBeAddThisParameterForExtensionFunction(@NotNull List<JsParameter> jsParameters) {
        if (this.isExtensionFunction()) {
            assert (this.extensionFunctionReceiverName != null);
            jsParameters.add(new JsParameter(this.extensionFunctionReceiverName));
        }
    }

    private boolean isExtensionFunction() {
        return JsDescriptorUtils.isExtension(this.descriptor) && !this.isLiteral();
    }

    private boolean isLiteral() {
        return this.functionDeclaration instanceof JetFunctionLiteralExpression;
    }
}

