/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExprStmt;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.FunctionTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class PropertyTranslator
extends AbstractTranslator {
    @NotNull
    private final PropertyDescriptor property;
    @NotNull
    private final List<JsPropertyInitializer> accessors = new ArrayList<JsPropertyInitializer>();
    @Nullable
    private final JetProperty declaration;

    @NotNull
    public static List<JsPropertyInitializer> translateAccessors(@NotNull PropertyDescriptor descriptor, @NotNull TranslationContext context) {
        if (context.isEcma5() && !JsDescriptorUtils.isAsPrivate(descriptor)) {
            return Collections.emptyList();
        }
        PropertyTranslator propertyTranslator = new PropertyTranslator(descriptor, context);
        List<JsPropertyInitializer> propertyInitializers = propertyTranslator.translate();
        if (context.isEcma5() && !JsDescriptorUtils.isExtension(descriptor)) {
            return PropertyTranslator.translateAsEcma5Accessors(descriptor, propertyInitializers, context);
        }
        return propertyInitializers;
    }

    @NotNull
    private static List<JsPropertyInitializer> translateAsEcma5Accessors(@NotNull PropertyDescriptor descriptor, @NotNull List<JsPropertyInitializer> propertyInitializers, @NotNull TranslationContext context) {
        JsObjectLiteral objectLiteral = new JsObjectLiteral();
        objectLiteral.getPropertyInitializers().addAll(propertyInitializers);
        JsStringLiteral propertyNameLiteral = context.program().getStringLiteral(descriptor.getName().getName());
        return Collections.singletonList(new JsPropertyInitializer(propertyNameLiteral, objectLiteral));
    }

    private PropertyTranslator(@NotNull PropertyDescriptor property, @NotNull TranslationContext context) {
        super(context);
        this.property = property;
        this.declaration = BindingUtils.getPropertyForDescriptor(this.bindingContext(), property);
    }

    @NotNull
    private List<JsPropertyInitializer> translate() {
        this.addGetter();
        if (this.property.isVar()) {
            this.addSetter();
        }
        return this.accessors;
    }

    private void addGetter() {
        if (this.hasCustomGetter()) {
            this.accessors.add(this.translateCustomAccessor(this.getCustomGetterDeclaration()));
        } else {
            this.accessors.add(this.generateDefaultGetter());
        }
    }

    private void addSetter() {
        if (this.hasCustomSetter()) {
            this.accessors.add(this.translateCustomAccessor(this.getCustomSetterDeclaration()));
        } else {
            this.accessors.add(this.generateDefaultSetter());
        }
    }

    private boolean hasCustomGetter() {
        return this.declaration != null && this.declaration.getGetter() != null && this.getCustomGetterDeclaration().getBodyExpression() != null;
    }

    private boolean hasCustomSetter() {
        return this.declaration != null && this.declaration.getSetter() != null && this.getCustomSetterDeclaration().getBodyExpression() != null;
    }

    @NotNull
    private JetPropertyAccessor getCustomGetterDeclaration() {
        assert (this.declaration != null);
        JetPropertyAccessor getterDeclaration = this.declaration.getGetter();
        assert (getterDeclaration != null);
        return getterDeclaration;
    }

    @NotNull
    private JetPropertyAccessor getCustomSetterDeclaration() {
        assert (this.declaration != null);
        JetPropertyAccessor setter = this.declaration.getSetter();
        assert (setter != null);
        return setter;
    }

    @NotNull
    private JsPropertyInitializer generateDefaultGetter() {
        PropertyGetterDescriptor getterDescriptor = this.property.getGetter();
        assert (getterDescriptor != null) : "Getter descriptor should not be null";
        return this.generateDefaultAccessor(getterDescriptor, this.generateDefaultGetterFunction(getterDescriptor));
    }

    @NotNull
    private JsFunction generateDefaultGetterFunction(@NotNull PropertyGetterDescriptor descriptor) {
        JsReturn returnExpression = new JsReturn(TranslationUtils.backingFieldReference(this.context(), this.property));
        JsFunction getterFunction = this.context().getFunctionObject(descriptor);
        getterFunction.getBody().getStatements().add(returnExpression);
        return getterFunction;
    }

    @NotNull
    private JsPropertyInitializer generateDefaultSetter() {
        PropertySetterDescriptor setterDescriptor = this.property.getSetter();
        assert (setterDescriptor != null) : "Setter descriptor should not be null";
        return this.generateDefaultAccessor(setterDescriptor, this.generateDefaultSetterFunction(setterDescriptor));
    }

    @NotNull
    private JsFunction generateDefaultSetterFunction(@NotNull PropertySetterDescriptor propertySetterDescriptor) {
        JsFunction result = this.context().getFunctionObject(propertySetterDescriptor);
        JsParameter defaultParameter = new JsParameter(this.propertyAccessContext(propertySetterDescriptor).jsScope().declareTemporary());
        JsExprStmt assignment = TranslationUtils.assignmentToBackingField(this.context(), this.property, defaultParameter.getName().makeRef()).makeStmt();
        JsAstUtils.setParameters(result, defaultParameter);
        result.getBody().getStatements().add(assignment);
        return result;
    }

    @NotNull
    private JsPropertyInitializer generateDefaultAccessor(@NotNull PropertyAccessorDescriptor accessorDescriptor, @NotNull JsFunction function) {
        if (this.context().isEcma5()) {
            return TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function, accessorDescriptor, this.context());
        }
        return JsAstUtils.newNamedMethod(this.context().getNameForDescriptor(accessorDescriptor), function);
    }

    @NotNull
    private TranslationContext propertyAccessContext(@NotNull PropertySetterDescriptor propertySetterDescriptor) {
        return this.context().newDeclaration(propertySetterDescriptor);
    }

    @NotNull
    private JsPropertyInitializer translateCustomAccessor(@NotNull JetPropertyAccessor expression) {
        FunctionTranslator translator = Translation.functionTranslator(expression, this.context());
        return this.context().isEcma5() ? translator.translateAsEcma5PropertyDescriptor() : translator.translateAsMethod();
    }
}

