/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassDeclarationTranslator;
import org.jetbrains.k2js.translate.declaration.DeclarationBodyVisitor;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class NamespaceTranslator
extends AbstractTranslator {
    @NotNull
    private final NamespaceDescriptor descriptor;
    @NotNull
    private final JsName namespaceName;
    @NotNull
    private final ClassDeclarationTranslator classDeclarationTranslator;

    NamespaceTranslator(@NotNull NamespaceDescriptor descriptor, @NotNull ClassDeclarationTranslator classDeclarationTranslator, @NotNull TranslationContext context) {
        super(context.newDeclaration(descriptor));
        this.descriptor = descriptor;
        this.namespaceName = context.getNameForDescriptor(descriptor);
        this.classDeclarationTranslator = classDeclarationTranslator;
    }

    @NotNull
    public JsVars getDeclarationAsVar() {
        return JsAstUtils.newVar(this.namespaceName, this.getNamespaceDeclaration());
    }

    @NotNull
    public JsPropertyInitializer getDeclarationAsInitializer() {
        return new JsPropertyInitializer(this.namespaceName.makeRef(), this.getNamespaceDeclaration());
    }

    @NotNull
    private JsInvocation getNamespaceDeclaration() {
        JsInvocation namespaceDeclaration = this.namespaceCreateMethodInvocation();
        this.addNamespaceInitalizersAndProperties(namespaceDeclaration);
        namespaceDeclaration.getArguments().add(this.getClassesAndNestedNamespaces());
        return namespaceDeclaration;
    }

    private void addNamespaceInitalizersAndProperties(@NotNull JsInvocation namespaceDeclaration) {
        JsFunction initializer = Translation.generateNamespaceInitializerMethod(this.descriptor, this.context());
        List<JsPropertyInitializer> properties = new DeclarationBodyVisitor().traverseNamespace(this.descriptor, this.context());
        if (this.context().isEcma5()) {
            NamespaceTranslator.addEcma5InitializersAndProperties(namespaceDeclaration, initializer, properties);
        } else {
            NamespaceTranslator.addEcma3InitializersAndProperties(namespaceDeclaration, initializer, properties);
        }
    }

    private static void addEcma3InitializersAndProperties(@NotNull JsInvocation namespaceDeclaration, @NotNull JsFunction initializer, @NotNull List<JsPropertyInitializer> properties) {
        ArrayList<JsPropertyInitializer> propertyList = new ArrayList<JsPropertyInitializer>();
        propertyList.add(InitializerUtils.generateInitializeMethod(initializer));
        propertyList.addAll(properties);
        namespaceDeclaration.getArguments().add(JsAstUtils.newObjectLiteral(propertyList));
    }

    private static void addEcma5InitializersAndProperties(@NotNull JsInvocation namespaceDeclaration, @NotNull JsFunction initializer, @NotNull List<JsPropertyInitializer> properties) {
        namespaceDeclaration.getArguments().add(initializer);
        namespaceDeclaration.getArguments().add(JsAstUtils.newObjectLiteral(properties));
    }

    @NotNull
    private JsInvocation namespaceCreateMethodInvocation() {
        return AstUtil.newInvocation(this.context().namer().namespaceCreationMethodReference(), new JsExpression[0]);
    }

    @NotNull
    private JsObjectLiteral getClassesAndNestedNamespaces() {
        JsObjectLiteral classesAndNestedNamespaces = new JsObjectLiteral();
        classesAndNestedNamespaces.getPropertyInitializers().addAll(this.getClassesDefined());
        classesAndNestedNamespaces.getPropertyInitializers().addAll(this.getNestedNamespaceDeclarations());
        return classesAndNestedNamespaces;
    }

    @NotNull
    private List<JsPropertyInitializer> getClassesDefined() {
        return this.classDeclarationTranslator.classDeclarationsForNamespace(this.descriptor);
    }

    @NotNull
    private List<JsPropertyInitializer> getNestedNamespaceDeclarations() {
        if (DescriptorUtils.isRootNamespace(this.descriptor)) {
            return Lists.newArrayList();
        }
        ArrayList<JsPropertyInitializer> result = Lists.newArrayList();
        List<NamespaceDescriptor> nestedNamespaces = JsDescriptorUtils.getNestedNamespaces(this.descriptor);
        for (NamespaceDescriptor nestedNamespace : nestedNamespaces) {
            NamespaceTranslator nestedNamespaceTranslator = new NamespaceTranslator(nestedNamespace, this.classDeclarationTranslator, this.context());
            result.add(nestedNamespaceTranslator.getDeclarationAsInitializer());
        }
        return result;
    }
}

