/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassDeclarationTranslator;
import org.jetbrains.k2js.translate.declaration.NamespaceTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class NamespaceDeclarationTranslator
extends AbstractTranslator {
    @NotNull
    private final ClassDeclarationTranslator classDeclarationTranslator;
    @NotNull
    private final List<NamespaceDescriptor> namespaceDescriptors;

    public static List<JsStatement> translateFiles(@NotNull List<JetFile> files, @NotNull TranslationContext context) {
        Set<NamespaceDescriptor> namespaceDescriptorSet = BindingUtils.getAllNonNativeNamespaceDescriptors(context.bindingContext(), files);
        return new NamespaceDeclarationTranslator(Lists.newArrayList(namespaceDescriptorSet), context).translate();
    }

    private NamespaceDeclarationTranslator(@NotNull List<NamespaceDescriptor> namespaceDescriptors, @NotNull TranslationContext context) {
        super(context);
        this.namespaceDescriptors = namespaceDescriptors;
        this.classDeclarationTranslator = new ClassDeclarationTranslator(this.getAllClasses(), context);
    }

    @NotNull
    private List<ClassDescriptor> getAllClasses() {
        ArrayList<ClassDescriptor> result = Lists.newArrayList();
        for (NamespaceDescriptor namespaceDescriptor : this.namespaceDescriptors) {
            result.addAll(JsDescriptorUtils.getAllClassesDefinedInNamespace(namespaceDescriptor));
        }
        return result;
    }

    @NotNull
    private List<JsStatement> translate() {
        List<JsStatement> result = this.classesDeclarations();
        result.addAll(this.namespacesDeclarations());
        return result;
    }

    @NotNull
    private List<JsStatement> classesDeclarations() {
        ArrayList<JsStatement> result = Lists.newArrayList();
        this.classDeclarationTranslator.generateDeclarations();
        result.add(this.classDeclarationTranslator.getDeclarationsStatement());
        return result;
    }

    @NotNull
    private List<JsStatement> namespacesDeclarations() {
        ArrayList<JsStatement> result = Lists.newArrayList();
        List<NamespaceTranslator> namespaceTranslators = this.getTranslatorsForNonEmptyNamespaces();
        result.addAll(NamespaceDeclarationTranslator.declarationStatements(namespaceTranslators, this.context()));
        result.addAll(this.initializeStatements(namespaceTranslators));
        return result;
    }

    @NotNull
    private List<NamespaceTranslator> getTranslatorsForNonEmptyNamespaces() {
        ArrayList<NamespaceTranslator> namespaceTranslators = Lists.newArrayList();
        for (NamespaceDescriptor descriptor : NamespaceDeclarationTranslator.filterNonEmptyNamespaces(NamespaceDeclarationTranslator.filterTopLevelAndRootNamespaces(this.namespaceDescriptors))) {
            namespaceTranslators.add(new NamespaceTranslator(descriptor, this.classDeclarationTranslator, this.context()));
        }
        return namespaceTranslators;
    }

    @NotNull
    private static List<JsStatement> declarationStatements(@NotNull List<NamespaceTranslator> namespaceTranslators, TranslationContext context) {
        ArrayList<JsStatement> result = Lists.newArrayList();
        JsNameRef defs = JsAstUtils.qualified(context.jsScope().declareName("defs"), context.namer().kotlinObject());
        for (NamespaceTranslator translator : namespaceTranslators) {
            JsVars vars = translator.getDeclarationAsVar();
            JsVars.JsVar var = vars.iterator().next();
            JsNameRef ref = new JsNameRef(var.getName());
            ref.setQualifier(defs);
            result.add(vars);
            result.add(JsAstUtils.assignment(ref, new JsNameRef(var.getName())).makeStmt());
        }
        return result;
    }

    @NotNull
    private List<JsStatement> initializeStatements(@NotNull List<NamespaceTranslator> namespaceTranslators) {
        ArrayList<JsStatement> result = Lists.newArrayList();
        for (NamespaceDescriptor descriptor : NamespaceDeclarationTranslator.filterNonEmptyNamespaces(this.namespaceDescriptors)) {
            JsNameRef initializeMethodReference = Namer.initializeMethodReference();
            JsNameRef fqNamespaceNameRef = TranslationUtils.getQualifiedReference(this.context(), descriptor);
            JsAstUtils.setQualifier(initializeMethodReference, fqNamespaceNameRef);
            result.add(AstUtil.newInvocation(initializeMethodReference, new JsExpression[0]).makeStmt());
        }
        return result;
    }

    @NotNull
    private static List<NamespaceDescriptor> filterTopLevelAndRootNamespaces(@NotNull List<NamespaceDescriptor> namespaceDescriptors) {
        ArrayList<NamespaceDescriptor> result = Lists.newArrayList();
        for (NamespaceDescriptor descriptor : namespaceDescriptors) {
            if (!DescriptorUtils.isTopLevelNamespace(descriptor) && !DescriptorUtils.isRootNamespace(descriptor)) continue;
            result.add(descriptor);
        }
        return result;
    }

    @NotNull
    private static List<NamespaceDescriptor> filterNonEmptyNamespaces(@NotNull List<NamespaceDescriptor> namespaceDescriptors) {
        ArrayList<NamespaceDescriptor> result = Lists.newArrayList();
        for (NamespaceDescriptor descriptor : namespaceDescriptors) {
            if (JsDescriptorUtils.isNamespaceEmpty(descriptor)) continue;
            result.add(descriptor);
        }
        return result;
    }
}

